/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudFrontOriginAccessIdentityConfig
implements ToCopyableBuilder<Builder, CloudFrontOriginAccessIdentityConfig> {
    private final String callerReference;
    private final String comment;

    private CloudFrontOriginAccessIdentityConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.comment = builder.comment;
    }

    public String callerReference() {
        return this.callerReference;
    }

    public String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.callerReference() == null ? 0 : this.callerReference().hashCode());
        hashCode = 31 * hashCode + (this.comment() == null ? 0 : this.comment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentityConfig)) {
            return false;
        }
        CloudFrontOriginAccessIdentityConfig other = (CloudFrontOriginAccessIdentityConfig)obj;
        if (other.callerReference() == null ^ this.callerReference() == null) {
            return false;
        }
        if (other.callerReference() != null && !other.callerReference().equals(this.callerReference())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        return other.comment() == null || other.comment().equals(this.comment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.callerReference() != null) {
            sb.append("CallerReference: ").append(this.callerReference()).append(",");
        }
        if (this.comment() != null) {
            sb.append("Comment: ").append(this.comment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentityConfig model) {
            this.setCallerReference(model.callerReference);
            this.setComment(model.comment);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        public final String getComment() {
            return this.comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public CloudFrontOriginAccessIdentityConfig build() {
            return new CloudFrontOriginAccessIdentityConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudFrontOriginAccessIdentityConfig> {
        public Builder callerReference(String var1);

        public Builder comment(String var1);
    }
}

