/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum CertificateSource {
    Cloudfront("cloudfront"),
    Iam("iam"),
    Acm("acm");

    private final String value;

    private CertificateSource(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static CertificateSource fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(CertificateSource.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

