/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.services.cloudfront.transform.PathsUnmarshaller;

public class InvalidationBatchUnmarshaller
implements Unmarshaller<InvalidationBatch, StaxUnmarshallerContext> {
    private static InvalidationBatchUnmarshaller INSTANCE;

    public InvalidationBatch unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InvalidationBatch.Builder invalidationBatch = InvalidationBatch.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Paths", targetDepth)) {
                    invalidationBatch.paths(PathsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CallerReference", targetDepth)) continue;
                invalidationBatch.callerReference(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InvalidationBatch)invalidationBatch.build();
    }

    public static InvalidationBatchUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InvalidationBatchUnmarshaller();
        }
        return INSTANCE;
    }
}

