/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum HttpVersion {
    Http11("http1.1"),
    Http2("http2");

    private final String value;

    private HttpVersion(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static HttpVersion fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(HttpVersion.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

