/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.DistributionConfig;
import software.amazon.awssdk.services.cloudfront.transform.AliasesUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CacheBehaviorsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CustomErrorResponsesUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DefaultCacheBehaviorUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.LoggingConfigUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.OriginsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.RestrictionsUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ViewerCertificateUnmarshaller;

public class DistributionConfigUnmarshaller
implements Unmarshaller<DistributionConfig, StaxUnmarshallerContext> {
    private static final DistributionConfigUnmarshaller INSTANCE = new DistributionConfigUnmarshaller();

    public DistributionConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DistributionConfig.Builder distributionConfig = DistributionConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CallerReference", targetDepth)) {
                    distributionConfig.callerReference(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Aliases", targetDepth)) {
                    distributionConfig.aliases(AliasesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultRootObject", targetDepth)) {
                    distributionConfig.defaultRootObject(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Origins", targetDepth)) {
                    distributionConfig.origins(OriginsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultCacheBehavior", targetDepth)) {
                    distributionConfig.defaultCacheBehavior(DefaultCacheBehaviorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CacheBehaviors", targetDepth)) {
                    distributionConfig.cacheBehaviors(CacheBehaviorsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomErrorResponses", targetDepth)) {
                    distributionConfig.customErrorResponses(CustomErrorResponsesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Comment", targetDepth)) {
                    distributionConfig.comment(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Logging", targetDepth)) {
                    distributionConfig.logging(LoggingConfigUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PriceClass", targetDepth)) {
                    distributionConfig.priceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    distributionConfig.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ViewerCertificate", targetDepth)) {
                    distributionConfig.viewerCertificate(ViewerCertificateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Restrictions", targetDepth)) {
                    distributionConfig.restrictions(RestrictionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("WebACLId", targetDepth)) {
                    distributionConfig.webACLId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HttpVersion", targetDepth)) {
                    distributionConfig.httpVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsIPV6Enabled", targetDepth)) continue;
                distributionConfig.isIPV6Enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DistributionConfig)distributionConfig.build();
    }

    public static DistributionConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

