/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.http.response.DefaultErrorResponseHandler;
import software.amazon.awssdk.awscore.http.response.StaxResponseHandler;
import software.amazon.awssdk.awscore.protocol.xml.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteServiceLinkedRoleRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteServiceLinkedRoleResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.AccessDeniedExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.BatchTooLargeExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CloudFrontOriginAccessIdentityAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CloudFrontOriginAccessIdentityInUseExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CnameAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteServiceLinkedRoleRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteServiceLinkedRoleResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DistributionAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DistributionNotDisabledExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.IllegalUpdateExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InconsistentQuantitiesExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidArgumentExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidDefaultRootObjectExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidErrorCodeExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidForwardCookiesExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidGeoRestrictionParameterExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidHeadersForS3OriginExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidIfMatchVersionExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidLambdaFunctionAssociationExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidLocationCodeExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidMinimumProtocolVersionExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidOriginAccessIdentityExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidOriginExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidOriginKeepaliveTimeoutExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidOriginReadTimeoutExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidProtocolSettingsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidQueryStringParametersExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidRelativePathExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidRequiredProtocolExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidResponseCodeExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidTaggingExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidTtlOrderExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidViewerCertificateExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.InvalidWebAclIdExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.MissingBodyExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.NoSuchCloudFrontOriginAccessIdentityExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.NoSuchDistributionExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.NoSuchInvalidationExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.NoSuchOriginExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.NoSuchResourceExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.NoSuchStreamingDistributionExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.PreconditionFailedExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ResourceInUseExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.StreamingDistributionAlreadyExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.StreamingDistributionNotDisabledExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyCacheBehaviorsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyCertificatesExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyCloudFrontOriginAccessIdentitiesExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyCookieNamesInWhiteListExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyDistributionCnamEsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyDistributionsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyDistributionsWithLambdaAssociationsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyHeadersInForwardedValuesExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyInvalidationsInProgressExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyLambdaFunctionAssociationsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyOriginCustomHeadersExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyOriginsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyQueryStringParametersExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyStreamingDistributionCnamEsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyStreamingDistributionsExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TooManyTrustedSignersExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TrustedSignerDoesNotExistExceptionUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionResponseUnmarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionResponseUnmarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudFrontAsyncClient
implements CloudFrontAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudFrontAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<AwsServiceException, Node>> exceptionUnmarshallers;

    protected DefaultCloudFrontAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.exceptionUnmarshallers = this.init();
    }

    public final String serviceName() {
        return "cloudfront";
    }

    @Override
    public CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> createCloudFrontOriginAccessIdentity(CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateCloudFrontOriginAccessIdentityResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateCloudFrontOriginAccessIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createCloudFrontOriginAccessIdentityRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDistributionWithTagsResponse> createDistributionWithTags(CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateDistributionWithTagsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateDistributionWithTagsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createDistributionWithTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInvalidationResponse> createInvalidation(CreateInvalidationRequest createInvalidationRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateInvalidationResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateInvalidationRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createInvalidationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamingDistributionResponse> createStreamingDistribution(CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateStreamingDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateStreamingDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createStreamingDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamingDistributionWithTagsResponse> createStreamingDistributionWithTags(CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateStreamingDistributionWithTagsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateStreamingDistributionWithTagsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createStreamingDistributionWithTagsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> deleteCloudFrontOriginAccessIdentity(DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteCloudFrontOriginAccessIdentityResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteCloudFrontOriginAccessIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteCloudFrontOriginAccessIdentityRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteServiceLinkedRoleResponse> deleteServiceLinkedRole(DeleteServiceLinkedRoleRequest deleteServiceLinkedRoleRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteServiceLinkedRoleResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteServiceLinkedRoleRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteServiceLinkedRoleRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStreamingDistributionResponse> deleteStreamingDistribution(DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteStreamingDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteStreamingDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteStreamingDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> getCloudFrontOriginAccessIdentity(GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetCloudFrontOriginAccessIdentityResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getCloudFrontOriginAccessIdentityRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> getCloudFrontOriginAccessIdentityConfig(GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetCloudFrontOriginAccessIdentityConfigResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getCloudFrontOriginAccessIdentityConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionResponse> getDistribution(GetDistributionRequest getDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDistributionConfigResponse> getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetDistributionConfigResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetDistributionConfigRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getDistributionConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInvalidationResponse> getInvalidation(GetInvalidationRequest getInvalidationRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetInvalidationResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetInvalidationRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getInvalidationRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStreamingDistributionResponse> getStreamingDistribution(GetStreamingDistributionRequest getStreamingDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetStreamingDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetStreamingDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getStreamingDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStreamingDistributionConfigResponse> getStreamingDistributionConfig(GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetStreamingDistributionConfigResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetStreamingDistributionConfigRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getStreamingDistributionConfigRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities(ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListCloudFrontOriginAccessIdentitiesResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListCloudFrontOriginAccessIdentitiesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listCloudFrontOriginAccessIdentitiesRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsResponse> listDistributions(ListDistributionsRequest listDistributionsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDistributionsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListDistributionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listDistributionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDistributionsByWebAclIdResponse> listDistributionsByWebACLId(ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDistributionsByWebAclIdResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListDistributionsByWebAclIdRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listDistributionsByWebAclIdRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInvalidationsResponse> listInvalidations(ListInvalidationsRequest listInvalidationsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListInvalidationsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListInvalidationsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listInvalidationsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions(ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListStreamingDistributionsResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListStreamingDistributionsRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listStreamingDistributionsRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListTagsForResourceResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new TagResourceResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new TagResourceRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)tagResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UntagResourceResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UntagResourceRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)untagResourceRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> updateCloudFrontOriginAccessIdentity(UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateCloudFrontOriginAccessIdentityResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateCloudFrontOriginAccessIdentityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)updateCloudFrontOriginAccessIdentityRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)updateDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStreamingDistributionResponse> updateStreamingDistribution(UpdateStreamingDistributionRequest updateStreamingDistributionRequest) {
        try {
            StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UpdateStreamingDistributionResponseUnmarshaller());
            DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
            return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new UpdateStreamingDistributionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)updateStreamingDistributionRequest));
        }
        catch (Throwable t) {
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private List<Unmarshaller<AwsServiceException, Node>> init() {
        ArrayList<Unmarshaller<AwsServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AwsServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StreamingDistributionAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TrustedSignerDoesNotExistExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidProtocolSettingsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyOriginCustomHeadersExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new NoSuchInvalidationExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidLocationCodeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new ResourceInUseExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidForwardCookiesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyCertificatesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidOriginAccessIdentityExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidQueryStringParametersExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new IllegalUpdateExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyCookieNamesInWhiteListExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyHeadersInForwardedValuesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidOriginReadTimeoutExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidMinimumProtocolVersionExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new NoSuchDistributionExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyInvalidationsInProgressExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new CnameAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new NoSuchResourceExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidTtlOrderExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidErrorCodeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyCacheBehaviorsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InconsistentQuantitiesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new CloudFrontOriginAccessIdentityInUseExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidLambdaFunctionAssociationExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyLambdaFunctionAssociationsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidViewerCertificateExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DistributionNotDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new MissingBodyExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidDefaultRootObjectExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new AccessDeniedExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyOriginsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidRequiredProtocolExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidArgumentExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new NoSuchOriginExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyTrustedSignersExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new NoSuchStreamingDistributionExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyCloudFrontOriginAccessIdentitiesExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new BatchTooLargeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidResponseCodeExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidRelativePathExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidOriginKeepaliveTimeoutExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidWebAclIdExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyStreamingDistributionCnamEsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyDistributionsWithLambdaAssociationsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyStreamingDistributionsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidHeadersForS3OriginExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyDistributionsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StreamingDistributionNotDisabledExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyDistributionCnamEsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new PreconditionFailedExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new TooManyQueryStringParametersExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new DistributionAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidIfMatchVersionExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new CloudFrontOriginAccessIdentityAlreadyExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidTaggingExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidOriginExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new NoSuchCloudFrontOriginAccessIdentityExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new InvalidGeoRestrictionParameterExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AwsServiceException, Node>)new StandardErrorUnmarshaller(CloudFrontException.class));
        return unmarshallers;
    }

    private <T extends CloudFrontRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudFrontRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

