/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.cloudfront.CloudFrontAsyncClient;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;

public class ListDistributionsPublisher
implements SdkPublisher<ListDistributionsResponse> {
    private final CloudFrontAsyncClient client;
    private final ListDistributionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDistributionsPublisher(CloudFrontAsyncClient client, ListDistributionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDistributionsPublisher(CloudFrontAsyncClient client, ListDistributionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDistributionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDistributionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DistributionSummary> items() {
        Function<ListDistributionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.distributionList() != null && response.distributionList().items() != null) {
                return response.distributionList().items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDistributionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListDistributionsPublisher resume(ListDistributionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDistributionsPublisher(this.client, (ListDistributionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.distributionList().nextMarker()).build()));
        }
        return new ListDistributionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListDistributionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListDistributionsResponseFetcher
    implements AsyncPageFetcher<ListDistributionsResponse> {
        private ListDistributionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDistributionsResponse previousPage) {
            return previousPage.distributionList().isTruncated();
        }

        public CompletableFuture<ListDistributionsResponse> nextPage(ListDistributionsResponse previousPage) {
            if (previousPage == null) {
                return ListDistributionsPublisher.this.client.listDistributions(ListDistributionsPublisher.this.firstRequest);
            }
            return ListDistributionsPublisher.this.client.listDistributions((ListDistributionsRequest)((Object)ListDistributionsPublisher.this.firstRequest.toBuilder().marker(previousPage.distributionList().nextMarker()).build()));
        }
    }
}

