/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.LoggingConfig;

public class LoggingConfigUnmarshaller
implements Unmarshaller<LoggingConfig, StaxUnmarshallerContext> {
    private static final LoggingConfigUnmarshaller INSTANCE = new LoggingConfigUnmarshaller();

    public LoggingConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LoggingConfig.Builder loggingConfig = LoggingConfig.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Enabled", targetDepth)) {
                    loggingConfig.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IncludeCookies", targetDepth)) {
                    loggingConfig.includeCookies(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Bucket", targetDepth)) {
                    loggingConfig.bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Prefix", targetDepth)) continue;
                loggingConfig.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LoggingConfig)loggingConfig.build();
    }

    public static LoggingConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

