/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.GeoRestriction;

public class GeoRestrictionUnmarshaller
implements Unmarshaller<GeoRestriction, StaxUnmarshallerContext> {
    private static GeoRestrictionUnmarshaller INSTANCE;

    public GeoRestriction unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        GeoRestriction.Builder geoRestriction = GeoRestriction.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("RestrictionType", targetDepth)) {
                    geoRestriction.restrictionType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Quantity", targetDepth)) {
                    geoRestriction.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    geoRestriction.items(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/Location", targetDepth)) continue;
                geoRestriction.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (GeoRestriction)geoRestriction.build();
    }

    public static GeoRestrictionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GeoRestrictionUnmarshaller();
        }
        return INSTANCE;
    }
}

