/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudfront.model.AllowedMethods;
import software.amazon.awssdk.services.cloudfront.transform.CachedMethodsUnmarshaller;

public class AllowedMethodsUnmarshaller
implements Unmarshaller<AllowedMethods, StaxUnmarshallerContext> {
    private static AllowedMethodsUnmarshaller INSTANCE;

    public AllowedMethods unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AllowedMethods.Builder allowedMethods = AllowedMethods.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    allowedMethods.quantity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    allowedMethods.items(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Items/Method", targetDepth)) {
                    allowedMethods.items(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CachedMethods", targetDepth)) continue;
                allowedMethods.cachedMethods(CachedMethodsUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AllowedMethods)allowedMethods.build();
    }

    public static AllowedMethodsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AllowedMethodsUnmarshaller();
        }
        return INSTANCE;
    }
}

