/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudfront.model.Tag;
import software.amazon.awssdk.services.cloudfront.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Tags
implements ToCopyableBuilder<Builder, Tags> {
    private final List<Tag> items;

    private Tags(BuilderImpl builder) {
        this.items = builder.items;
    }

    public List<Tag> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tags)) {
            return false;
        }
        Tags other = (Tags)obj;
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Tag> items = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Tags model) {
            this.setItems(model.items);
        }

        public final Collection<Tag> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<Tag> items) {
            this.items = TagListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Tag ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (Tag e : items) {
                this.items.add(e);
            }
            return this;
        }

        public final void setItems(Collection<Tag> items) {
            this.items = TagListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(Tag ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (Tag e : items) {
                this.items.add(e);
            }
        }

        public Tags build() {
            return new Tags(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Tags> {
        public Builder items(Collection<Tag> var1);

        public Builder items(Tag ... var1);
    }
}

