/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudfront.model.Signer;
import software.amazon.awssdk.services.cloudfront.model.SignerListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ActiveTrustedSigners
implements ToCopyableBuilder<Builder, ActiveTrustedSigners> {
    private final Boolean enabled;
    private final Integer quantity;
    private final List<Signer> items;

    private ActiveTrustedSigners(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public Integer quantity() {
        return this.quantity;
    }

    public List<Signer> items() {
        return this.items;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.enabled() == null ? 0 : this.enabled().hashCode());
        hashCode = 31 * hashCode + (this.quantity() == null ? 0 : this.quantity().hashCode());
        hashCode = 31 * hashCode + (this.items() == null ? 0 : this.items().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveTrustedSigners)) {
            return false;
        }
        ActiveTrustedSigners other = (ActiveTrustedSigners)obj;
        if (other.enabled() == null ^ this.enabled() == null) {
            return false;
        }
        if (other.enabled() != null && !other.enabled().equals(this.enabled())) {
            return false;
        }
        if (other.quantity() == null ^ this.quantity() == null) {
            return false;
        }
        if (other.quantity() != null && !other.quantity().equals(this.quantity())) {
            return false;
        }
        if (other.items() == null ^ this.items() == null) {
            return false;
        }
        return other.items() == null || other.items().equals(this.items());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.quantity() != null) {
            sb.append("Quantity: ").append(this.quantity()).append(",");
        }
        if (this.items() != null) {
            sb.append("Items: ").append(this.items()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer quantity;
        private List<Signer> items = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveTrustedSigners model) {
            this.setEnabled(model.enabled);
            this.setQuantity(model.quantity);
            this.setItems(model.items);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Integer getQuantity() {
            return this.quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        public final Collection<Signer> getItems() {
            return this.items;
        }

        @Override
        public final Builder items(Collection<Signer> items) {
            this.items = SignerListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Signer ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (Signer e : items) {
                this.items.add(e);
            }
            return this;
        }

        public final void setItems(Collection<Signer> items) {
            this.items = SignerListCopier.copy(items);
        }

        @SafeVarargs
        public final void setItems(Signer ... items) {
            if (this.items == null) {
                this.items = new SdkInternalList(items.length);
            }
            for (Signer e : items) {
                this.items.add(e);
            }
        }

        public ActiveTrustedSigners build() {
            return new ActiveTrustedSigners(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ActiveTrustedSigners> {
        public Builder enabled(Boolean var1);

        public Builder quantity(Integer var1);

        public Builder items(Collection<Signer> var1);

        public Builder items(Signer ... var1);
    }
}

