/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.PhysicalResourceIdContextCopier;
import software.amazon.awssdk.services.cloudformation.model.PhysicalResourceIdContextKeyValuePair;
import software.amazon.awssdk.services.cloudformation.model.PropertyDifference;
import software.amazon.awssdk.services.cloudformation.model.PropertyDifferencesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackResourceDrift
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackResourceDrift> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDrift.getter(StackResourceDrift::stackId)).setter(StackResourceDrift.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDrift.getter(StackResourceDrift::logicalResourceId)).setter(StackResourceDrift.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDrift.getter(StackResourceDrift::physicalResourceId)).setter(StackResourceDrift.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build()}).build();
    private static final SdkField<List<PhysicalResourceIdContextKeyValuePair>> PHYSICAL_RESOURCE_ID_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StackResourceDrift.getter(StackResourceDrift::physicalResourceIdContext)).setter(StackResourceDrift.setter(Builder::physicalResourceIdContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceIdContext").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhysicalResourceIdContextKeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDrift.getter(StackResourceDrift::resourceType)).setter(StackResourceDrift.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> EXPECTED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDrift.getter(StackResourceDrift::expectedProperties)).setter(StackResourceDrift.setter(Builder::expectedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedProperties").build()}).build();
    private static final SdkField<String> ACTUAL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDrift.getter(StackResourceDrift::actualProperties)).setter(StackResourceDrift.setter(Builder::actualProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualProperties").build()}).build();
    private static final SdkField<List<PropertyDifference>> PROPERTY_DIFFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(StackResourceDrift.getter(StackResourceDrift::propertyDifferences)).setter(StackResourceDrift.setter(Builder::propertyDifferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyDifferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyDifference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STACK_RESOURCE_DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StackResourceDrift.getter(StackResourceDrift::stackResourceDriftStatusAsString)).setter(StackResourceDrift.setter(Builder::stackResourceDriftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDriftStatus").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(StackResourceDrift.getter(StackResourceDrift::timestamp)).setter(StackResourceDrift.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_CONTEXT_FIELD, RESOURCE_TYPE_FIELD, EXPECTED_PROPERTIES_FIELD, ACTUAL_PROPERTIES_FIELD, PROPERTY_DIFFERENCES_FIELD, STACK_RESOURCE_DRIFT_STATUS_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final List<PhysicalResourceIdContextKeyValuePair> physicalResourceIdContext;
    private final String resourceType;
    private final String expectedProperties;
    private final String actualProperties;
    private final List<PropertyDifference> propertyDifferences;
    private final String stackResourceDriftStatus;
    private final Instant timestamp;

    private StackResourceDrift(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.physicalResourceIdContext = builder.physicalResourceIdContext;
        this.resourceType = builder.resourceType;
        this.expectedProperties = builder.expectedProperties;
        this.actualProperties = builder.actualProperties;
        this.propertyDifferences = builder.propertyDifferences;
        this.stackResourceDriftStatus = builder.stackResourceDriftStatus;
        this.timestamp = builder.timestamp;
    }

    public String stackId() {
        return this.stackId;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public List<PhysicalResourceIdContextKeyValuePair> physicalResourceIdContext() {
        return this.physicalResourceIdContext;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String expectedProperties() {
        return this.expectedProperties;
    }

    public String actualProperties() {
        return this.actualProperties;
    }

    public List<PropertyDifference> propertyDifferences() {
        return this.propertyDifferences;
    }

    public StackResourceDriftStatus stackResourceDriftStatus() {
        return StackResourceDriftStatus.fromValue(this.stackResourceDriftStatus);
    }

    public String stackResourceDriftStatusAsString() {
        return this.stackResourceDriftStatus;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceIdContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyDifferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackResourceDriftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResourceDrift)) {
            return false;
        }
        StackResourceDrift other = (StackResourceDrift)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.physicalResourceIdContext(), other.physicalResourceIdContext()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.expectedProperties(), other.expectedProperties()) && Objects.equals(this.actualProperties(), other.actualProperties()) && Objects.equals(this.propertyDifferences(), other.propertyDifferences()) && Objects.equals(this.stackResourceDriftStatusAsString(), other.stackResourceDriftStatusAsString()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"StackResourceDrift").add("StackId", (Object)this.stackId()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("PhysicalResourceIdContext", this.physicalResourceIdContext()).add("ResourceType", (Object)this.resourceType()).add("ExpectedProperties", (Object)this.expectedProperties()).add("ActualProperties", (Object)this.actualProperties()).add("PropertyDifferences", this.propertyDifferences()).add("StackResourceDriftStatus", (Object)this.stackResourceDriftStatusAsString()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "PhysicalResourceIdContext": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceIdContext()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "ExpectedProperties": {
                return Optional.ofNullable(clazz.cast(this.expectedProperties()));
            }
            case "ActualProperties": {
                return Optional.ofNullable(clazz.cast(this.actualProperties()));
            }
            case "PropertyDifferences": {
                return Optional.ofNullable(clazz.cast(this.propertyDifferences()));
            }
            case "StackResourceDriftStatus": {
                return Optional.ofNullable(clazz.cast(this.stackResourceDriftStatusAsString()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackResourceDrift, T> g) {
        return obj -> g.apply((StackResourceDrift)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String logicalResourceId;
        private String physicalResourceId;
        private List<PhysicalResourceIdContextKeyValuePair> physicalResourceIdContext = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;
        private String expectedProperties;
        private String actualProperties;
        private List<PropertyDifference> propertyDifferences = DefaultSdkAutoConstructList.getInstance();
        private String stackResourceDriftStatus;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResourceDrift model) {
            this.stackId(model.stackId);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.physicalResourceIdContext(model.physicalResourceIdContext);
            this.resourceType(model.resourceType);
            this.expectedProperties(model.expectedProperties);
            this.actualProperties(model.actualProperties);
            this.propertyDifferences(model.propertyDifferences);
            this.stackResourceDriftStatus(model.stackResourceDriftStatus);
            this.timestamp(model.timestamp);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final Collection<PhysicalResourceIdContextKeyValuePair.Builder> getPhysicalResourceIdContext() {
            return this.physicalResourceIdContext != null ? (Collection)this.physicalResourceIdContext.stream().map(PhysicalResourceIdContextKeyValuePair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder physicalResourceIdContext(Collection<PhysicalResourceIdContextKeyValuePair> physicalResourceIdContext) {
            this.physicalResourceIdContext = PhysicalResourceIdContextCopier.copy(physicalResourceIdContext);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalResourceIdContext(PhysicalResourceIdContextKeyValuePair ... physicalResourceIdContext) {
            this.physicalResourceIdContext(Arrays.asList(physicalResourceIdContext));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalResourceIdContext(Consumer<PhysicalResourceIdContextKeyValuePair.Builder> ... physicalResourceIdContext) {
            this.physicalResourceIdContext(Stream.of(physicalResourceIdContext).map(c -> (PhysicalResourceIdContextKeyValuePair)((PhysicalResourceIdContextKeyValuePair.Builder)PhysicalResourceIdContextKeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPhysicalResourceIdContext(Collection<PhysicalResourceIdContextKeyValuePair.BuilderImpl> physicalResourceIdContext) {
            this.physicalResourceIdContext = PhysicalResourceIdContextCopier.copyFromBuilder(physicalResourceIdContext);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getExpectedProperties() {
            return this.expectedProperties;
        }

        @Override
        public final Builder expectedProperties(String expectedProperties) {
            this.expectedProperties = expectedProperties;
            return this;
        }

        public final void setExpectedProperties(String expectedProperties) {
            this.expectedProperties = expectedProperties;
        }

        public final String getActualProperties() {
            return this.actualProperties;
        }

        @Override
        public final Builder actualProperties(String actualProperties) {
            this.actualProperties = actualProperties;
            return this;
        }

        public final void setActualProperties(String actualProperties) {
            this.actualProperties = actualProperties;
        }

        public final Collection<PropertyDifference.Builder> getPropertyDifferences() {
            return this.propertyDifferences != null ? (Collection)this.propertyDifferences.stream().map(PropertyDifference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder propertyDifferences(Collection<PropertyDifference> propertyDifferences) {
            this.propertyDifferences = PropertyDifferencesCopier.copy(propertyDifferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyDifferences(PropertyDifference ... propertyDifferences) {
            this.propertyDifferences(Arrays.asList(propertyDifferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyDifferences(Consumer<PropertyDifference.Builder> ... propertyDifferences) {
            this.propertyDifferences(Stream.of(propertyDifferences).map(c -> (PropertyDifference)((PropertyDifference.Builder)PropertyDifference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPropertyDifferences(Collection<PropertyDifference.BuilderImpl> propertyDifferences) {
            this.propertyDifferences = PropertyDifferencesCopier.copyFromBuilder(propertyDifferences);
        }

        public final String getStackResourceDriftStatusAsString() {
            return this.stackResourceDriftStatus;
        }

        @Override
        public final Builder stackResourceDriftStatus(String stackResourceDriftStatus) {
            this.stackResourceDriftStatus = stackResourceDriftStatus;
            return this;
        }

        @Override
        public final Builder stackResourceDriftStatus(StackResourceDriftStatus stackResourceDriftStatus) {
            this.stackResourceDriftStatus(stackResourceDriftStatus.toString());
            return this;
        }

        public final void setStackResourceDriftStatus(String stackResourceDriftStatus) {
            this.stackResourceDriftStatus = stackResourceDriftStatus;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public StackResourceDrift build() {
            return new StackResourceDrift(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackResourceDrift> {
        public Builder stackId(String var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder physicalResourceIdContext(Collection<PhysicalResourceIdContextKeyValuePair> var1);

        public Builder physicalResourceIdContext(PhysicalResourceIdContextKeyValuePair ... var1);

        public Builder physicalResourceIdContext(Consumer<PhysicalResourceIdContextKeyValuePair.Builder> ... var1);

        public Builder resourceType(String var1);

        public Builder expectedProperties(String var1);

        public Builder actualProperties(String var1);

        public Builder propertyDifferences(Collection<PropertyDifference> var1);

        public Builder propertyDifferences(PropertyDifference ... var1);

        public Builder propertyDifferences(Consumer<PropertyDifference.Builder> ... var1);

        public Builder stackResourceDriftStatus(String var1);

        public Builder stackResourceDriftStatus(StackResourceDriftStatus var1);

        public Builder timestamp(Instant var1);
    }
}

