/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.DifferenceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyDifference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyDifference> {
    private static final SdkField<String> PROPERTY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PropertyDifference.getter(PropertyDifference::propertyPath)).setter(PropertyDifference.setter(Builder::propertyPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyPath").build()}).build();
    private static final SdkField<String> EXPECTED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PropertyDifference.getter(PropertyDifference::expectedValue)).setter(PropertyDifference.setter(Builder::expectedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedValue").build()}).build();
    private static final SdkField<String> ACTUAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PropertyDifference.getter(PropertyDifference::actualValue)).setter(PropertyDifference.setter(Builder::actualValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualValue").build()}).build();
    private static final SdkField<String> DIFFERENCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PropertyDifference.getter(PropertyDifference::differenceTypeAsString)).setter(PropertyDifference.setter(Builder::differenceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DifferenceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_PATH_FIELD, EXPECTED_VALUE_FIELD, ACTUAL_VALUE_FIELD, DIFFERENCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String propertyPath;
    private final String expectedValue;
    private final String actualValue;
    private final String differenceType;

    private PropertyDifference(BuilderImpl builder) {
        this.propertyPath = builder.propertyPath;
        this.expectedValue = builder.expectedValue;
        this.actualValue = builder.actualValue;
        this.differenceType = builder.differenceType;
    }

    public String propertyPath() {
        return this.propertyPath;
    }

    public String expectedValue() {
        return this.expectedValue;
    }

    public String actualValue() {
        return this.actualValue;
    }

    public DifferenceType differenceType() {
        return DifferenceType.fromValue(this.differenceType);
    }

    public String differenceTypeAsString() {
        return this.differenceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.differenceTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyDifference)) {
            return false;
        }
        PropertyDifference other = (PropertyDifference)obj;
        return Objects.equals(this.propertyPath(), other.propertyPath()) && Objects.equals(this.expectedValue(), other.expectedValue()) && Objects.equals(this.actualValue(), other.actualValue()) && Objects.equals(this.differenceTypeAsString(), other.differenceTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"PropertyDifference").add("PropertyPath", (Object)this.propertyPath()).add("ExpectedValue", (Object)this.expectedValue()).add("ActualValue", (Object)this.actualValue()).add("DifferenceType", (Object)this.differenceTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PropertyPath": {
                return Optional.ofNullable(clazz.cast(this.propertyPath()));
            }
            case "ExpectedValue": {
                return Optional.ofNullable(clazz.cast(this.expectedValue()));
            }
            case "ActualValue": {
                return Optional.ofNullable(clazz.cast(this.actualValue()));
            }
            case "DifferenceType": {
                return Optional.ofNullable(clazz.cast(this.differenceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyDifference, T> g) {
        return obj -> g.apply((PropertyDifference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String propertyPath;
        private String expectedValue;
        private String actualValue;
        private String differenceType;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyDifference model) {
            this.propertyPath(model.propertyPath);
            this.expectedValue(model.expectedValue);
            this.actualValue(model.actualValue);
            this.differenceType(model.differenceType);
        }

        public final String getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        public final Builder propertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
            return this;
        }

        public final void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        public final String getExpectedValue() {
            return this.expectedValue;
        }

        @Override
        public final Builder expectedValue(String expectedValue) {
            this.expectedValue = expectedValue;
            return this;
        }

        public final void setExpectedValue(String expectedValue) {
            this.expectedValue = expectedValue;
        }

        public final String getActualValue() {
            return this.actualValue;
        }

        @Override
        public final Builder actualValue(String actualValue) {
            this.actualValue = actualValue;
            return this;
        }

        public final void setActualValue(String actualValue) {
            this.actualValue = actualValue;
        }

        public final String getDifferenceTypeAsString() {
            return this.differenceType;
        }

        @Override
        public final Builder differenceType(String differenceType) {
            this.differenceType = differenceType;
            return this;
        }

        @Override
        public final Builder differenceType(DifferenceType differenceType) {
            this.differenceType(differenceType.toString());
            return this;
        }

        public final void setDifferenceType(String differenceType) {
            this.differenceType = differenceType;
        }

        public PropertyDifference build() {
            return new PropertyDifference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyDifference> {
        public Builder propertyPath(String var1);

        public Builder expectedValue(String var1);

        public Builder actualValue(String var1);

        public Builder differenceType(String var1);

        public Builder differenceType(DifferenceType var1);
    }
}

