/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.Annotation;
import software.amazon.awssdk.services.cloudformation.model.AnnotationListCopier;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.HookFailureMode;
import software.amazon.awssdk.services.cloudformation.model.HookInvocationPoint;
import software.amazon.awssdk.services.cloudformation.model.HookStatus;
import software.amazon.awssdk.services.cloudformation.model.HookTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHookResultResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, GetHookResultResponse> {
    private static final SdkField<String> HOOK_RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookResultId").getter(GetHookResultResponse.getter(GetHookResultResponse::hookResultId)).setter(GetHookResultResponse.setter(Builder::hookResultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookResultId").build()}).build();
    private static final SdkField<String> INVOCATION_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvocationPoint").getter(GetHookResultResponse.getter(GetHookResultResponse::invocationPointAsString)).setter(GetHookResultResponse.setter(Builder::invocationPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPoint").build()}).build();
    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMode").getter(GetHookResultResponse.getter(GetHookResultResponse::failureModeAsString)).setter(GetHookResultResponse.setter(Builder::failureMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(GetHookResultResponse.getter(GetHookResultResponse::typeName)).setter(GetHookResultResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginalTypeName").getter(GetHookResultResponse.getter(GetHookResultResponse::originalTypeName)).setter(GetHookResultResponse.setter(Builder::originalTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()}).build();
    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeVersionId").getter(GetHookResultResponse.getter(GetHookResultResponse::typeVersionId)).setter(GetHookResultResponse.setter(Builder::typeVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()}).build();
    private static final SdkField<String> TYPE_CONFIGURATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeConfigurationVersionId").getter(GetHookResultResponse.getter(GetHookResultResponse::typeConfigurationVersionId)).setter(GetHookResultResponse.setter(Builder::typeConfigurationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationVersionId").build()}).build();
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeArn").getter(GetHookResultResponse.getter(GetHookResultResponse::typeArn)).setter(GetHookResultResponse.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetHookResultResponse.getter(GetHookResultResponse::statusAsString)).setter(GetHookResultResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HookStatusReason").getter(GetHookResultResponse.getter(GetHookResultResponse::hookStatusReason)).setter(GetHookResultResponse.setter(Builder::hookStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()}).build();
    private static final SdkField<Instant> INVOKED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InvokedAt").getter(GetHookResultResponse.getter(GetHookResultResponse::invokedAt)).setter(GetHookResultResponse.setter(Builder::invokedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokedAt").build()}).build();
    private static final SdkField<HookTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Target").getter(GetHookResultResponse.getter(GetHookResultResponse::target)).setter(GetHookResultResponse.setter(Builder::target)).constructor(HookTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<List<Annotation>> ANNOTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Annotations").getter(GetHookResultResponse.getter(GetHookResultResponse::annotations)).setter(GetHookResultResponse.setter(Builder::annotations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Annotation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOOK_RESULT_ID_FIELD, INVOCATION_POINT_FIELD, FAILURE_MODE_FIELD, TYPE_NAME_FIELD, ORIGINAL_TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD, TYPE_CONFIGURATION_VERSION_ID_FIELD, TYPE_ARN_FIELD, STATUS_FIELD, HOOK_STATUS_REASON_FIELD, INVOKED_AT_FIELD, TARGET_FIELD, ANNOTATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetHookResultResponse.memberNameToFieldInitializer();
    private final String hookResultId;
    private final String invocationPoint;
    private final String failureMode;
    private final String typeName;
    private final String originalTypeName;
    private final String typeVersionId;
    private final String typeConfigurationVersionId;
    private final String typeArn;
    private final String status;
    private final String hookStatusReason;
    private final Instant invokedAt;
    private final HookTarget target;
    private final List<Annotation> annotations;

    private GetHookResultResponse(BuilderImpl builder) {
        super(builder);
        this.hookResultId = builder.hookResultId;
        this.invocationPoint = builder.invocationPoint;
        this.failureMode = builder.failureMode;
        this.typeName = builder.typeName;
        this.originalTypeName = builder.originalTypeName;
        this.typeVersionId = builder.typeVersionId;
        this.typeConfigurationVersionId = builder.typeConfigurationVersionId;
        this.typeArn = builder.typeArn;
        this.status = builder.status;
        this.hookStatusReason = builder.hookStatusReason;
        this.invokedAt = builder.invokedAt;
        this.target = builder.target;
        this.annotations = builder.annotations;
    }

    public final String hookResultId() {
        return this.hookResultId;
    }

    public final HookInvocationPoint invocationPoint() {
        return HookInvocationPoint.fromValue(this.invocationPoint);
    }

    public final String invocationPointAsString() {
        return this.invocationPoint;
    }

    public final HookFailureMode failureMode() {
        return HookFailureMode.fromValue(this.failureMode);
    }

    public final String failureModeAsString() {
        return this.failureMode;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String originalTypeName() {
        return this.originalTypeName;
    }

    public final String typeVersionId() {
        return this.typeVersionId;
    }

    public final String typeConfigurationVersionId() {
        return this.typeConfigurationVersionId;
    }

    public final String typeArn() {
        return this.typeArn;
    }

    public final HookStatus status() {
        return HookStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String hookStatusReason() {
        return this.hookStatusReason;
    }

    public final Instant invokedAt() {
        return this.invokedAt;
    }

    public final HookTarget target() {
        return this.target;
    }

    public final boolean hasAnnotations() {
        return this.annotations != null && !(this.annotations instanceof SdkAutoConstructList);
    }

    public final List<Annotation> annotations() {
        return this.annotations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hookResultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeConfigurationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hookStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.invokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnnotations() ? this.annotations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHookResultResponse)) {
            return false;
        }
        GetHookResultResponse other = (GetHookResultResponse)((Object)obj);
        return Objects.equals(this.hookResultId(), other.hookResultId()) && Objects.equals(this.invocationPointAsString(), other.invocationPointAsString()) && Objects.equals(this.failureModeAsString(), other.failureModeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.originalTypeName(), other.originalTypeName()) && Objects.equals(this.typeVersionId(), other.typeVersionId()) && Objects.equals(this.typeConfigurationVersionId(), other.typeConfigurationVersionId()) && Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.hookStatusReason(), other.hookStatusReason()) && Objects.equals(this.invokedAt(), other.invokedAt()) && Objects.equals(this.target(), other.target()) && this.hasAnnotations() == other.hasAnnotations() && Objects.equals(this.annotations(), other.annotations());
    }

    public final String toString() {
        return ToString.builder((String)"GetHookResultResponse").add("HookResultId", (Object)this.hookResultId()).add("InvocationPoint", (Object)this.invocationPointAsString()).add("FailureMode", (Object)this.failureModeAsString()).add("TypeName", (Object)this.typeName()).add("OriginalTypeName", (Object)this.originalTypeName()).add("TypeVersionId", (Object)this.typeVersionId()).add("TypeConfigurationVersionId", (Object)this.typeConfigurationVersionId()).add("TypeArn", (Object)this.typeArn()).add("Status", (Object)this.statusAsString()).add("HookStatusReason", (Object)this.hookStatusReason()).add("InvokedAt", (Object)this.invokedAt()).add("Target", (Object)this.target()).add("Annotations", this.hasAnnotations() ? this.annotations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HookResultId": {
                return Optional.ofNullable(clazz.cast(this.hookResultId()));
            }
            case "InvocationPoint": {
                return Optional.ofNullable(clazz.cast(this.invocationPointAsString()));
            }
            case "FailureMode": {
                return Optional.ofNullable(clazz.cast(this.failureModeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "OriginalTypeName": {
                return Optional.ofNullable(clazz.cast(this.originalTypeName()));
            }
            case "TypeVersionId": {
                return Optional.ofNullable(clazz.cast(this.typeVersionId()));
            }
            case "TypeConfigurationVersionId": {
                return Optional.ofNullable(clazz.cast(this.typeConfigurationVersionId()));
            }
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "HookStatusReason": {
                return Optional.ofNullable(clazz.cast(this.hookStatusReason()));
            }
            case "InvokedAt": {
                return Optional.ofNullable(clazz.cast(this.invokedAt()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Annotations": {
                return Optional.ofNullable(clazz.cast(this.annotations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HookResultId", HOOK_RESULT_ID_FIELD);
        map.put("InvocationPoint", INVOCATION_POINT_FIELD);
        map.put("FailureMode", FAILURE_MODE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("OriginalTypeName", ORIGINAL_TYPE_NAME_FIELD);
        map.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
        map.put("TypeConfigurationVersionId", TYPE_CONFIGURATION_VERSION_ID_FIELD);
        map.put("TypeArn", TYPE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
        map.put("InvokedAt", INVOKED_AT_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("Annotations", ANNOTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHookResultResponse, T> g) {
        return obj -> g.apply((GetHookResultResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String hookResultId;
        private String invocationPoint;
        private String failureMode;
        private String typeName;
        private String originalTypeName;
        private String typeVersionId;
        private String typeConfigurationVersionId;
        private String typeArn;
        private String status;
        private String hookStatusReason;
        private Instant invokedAt;
        private HookTarget target;
        private List<Annotation> annotations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHookResultResponse model) {
            super(model);
            this.hookResultId(model.hookResultId);
            this.invocationPoint(model.invocationPoint);
            this.failureMode(model.failureMode);
            this.typeName(model.typeName);
            this.originalTypeName(model.originalTypeName);
            this.typeVersionId(model.typeVersionId);
            this.typeConfigurationVersionId(model.typeConfigurationVersionId);
            this.typeArn(model.typeArn);
            this.status(model.status);
            this.hookStatusReason(model.hookStatusReason);
            this.invokedAt(model.invokedAt);
            this.target(model.target);
            this.annotations(model.annotations);
        }

        public final String getHookResultId() {
            return this.hookResultId;
        }

        public final void setHookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
        }

        @Override
        public final Builder hookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
            return this;
        }

        public final String getInvocationPoint() {
            return this.invocationPoint;
        }

        public final void setInvocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
        }

        @Override
        public final Builder invocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
            return this;
        }

        @Override
        public final Builder invocationPoint(HookInvocationPoint invocationPoint) {
            this.invocationPoint(invocationPoint == null ? null : invocationPoint.toString());
            return this;
        }

        public final String getFailureMode() {
            return this.failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(HookFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getOriginalTypeName() {
            return this.originalTypeName;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final String getTypeVersionId() {
            return this.typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getTypeConfigurationVersionId() {
            return this.typeConfigurationVersionId;
        }

        public final void setTypeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
        }

        @Override
        public final Builder typeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
            return this;
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HookStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return this.hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public final Instant getInvokedAt() {
            return this.invokedAt;
        }

        public final void setInvokedAt(Instant invokedAt) {
            this.invokedAt = invokedAt;
        }

        @Override
        public final Builder invokedAt(Instant invokedAt) {
            this.invokedAt = invokedAt;
            return this;
        }

        public final HookTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(HookTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(HookTarget target) {
            this.target = target;
            return this;
        }

        public final List<Annotation.Builder> getAnnotations() {
            List<Annotation.Builder> result = AnnotationListCopier.copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Collection<Annotation.BuilderImpl> annotations) {
            this.annotations = AnnotationListCopier.copyFromBuilder(annotations);
        }

        @Override
        public final Builder annotations(Collection<Annotation> annotations) {
            this.annotations = AnnotationListCopier.copy(annotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Annotation ... annotations) {
            this.annotations(Arrays.asList(annotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Consumer<Annotation.Builder> ... annotations) {
            this.annotations(Stream.of(annotations).map(c -> (Annotation)((Annotation.Builder)Annotation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetHookResultResponse build() {
            return new GetHookResultResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHookResultResponse> {
        public Builder hookResultId(String var1);

        public Builder invocationPoint(String var1);

        public Builder invocationPoint(HookInvocationPoint var1);

        public Builder failureMode(String var1);

        public Builder failureMode(HookFailureMode var1);

        public Builder typeName(String var1);

        public Builder originalTypeName(String var1);

        public Builder typeVersionId(String var1);

        public Builder typeConfigurationVersionId(String var1);

        public Builder typeArn(String var1);

        public Builder status(String var1);

        public Builder status(HookStatus var1);

        public Builder hookStatusReason(String var1);

        public Builder invokedAt(Instant var1);

        public Builder target(HookTarget var1);

        default public Builder target(Consumer<HookTarget.Builder> target) {
            return this.target((HookTarget)((HookTarget.Builder)HookTarget.builder().applyMutation(target)).build());
        }

        public Builder annotations(Collection<Annotation> var1);

        public Builder annotations(Annotation ... var1);

        public Builder annotations(Consumer<Annotation.Builder> ... var1);
    }
}

