/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.AnnotationSeverityLevel;
import software.amazon.awssdk.services.cloudformation.model.AnnotationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Annotation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Annotation> {
    private static final SdkField<String> ANNOTATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnnotationName").getter(Annotation.getter(Annotation::annotationName)).setter(Annotation.setter(Builder::annotationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Annotation.getter(Annotation::statusAsString)).setter(Annotation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(Annotation.getter(Annotation::statusMessage)).setter(Annotation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> REMEDIATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemediationMessage").getter(Annotation.getter(Annotation::remediationMessage)).setter(Annotation.setter(Builder::remediationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationMessage").build()}).build();
    private static final SdkField<String> REMEDIATION_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemediationLink").getter(Annotation.getter(Annotation::remediationLink)).setter(Annotation.setter(Builder::remediationLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationLink").build()}).build();
    private static final SdkField<String> SEVERITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SeverityLevel").getter(Annotation.getter(Annotation::severityLevelAsString)).setter(Annotation.setter(Builder::severityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, REMEDIATION_MESSAGE_FIELD, REMEDIATION_LINK_FIELD, SEVERITY_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Annotation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String annotationName;
    private final String status;
    private final String statusMessage;
    private final String remediationMessage;
    private final String remediationLink;
    private final String severityLevel;

    private Annotation(BuilderImpl builder) {
        this.annotationName = builder.annotationName;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.remediationMessage = builder.remediationMessage;
        this.remediationLink = builder.remediationLink;
        this.severityLevel = builder.severityLevel;
    }

    public final String annotationName() {
        return this.annotationName;
    }

    public final AnnotationStatus status() {
        return AnnotationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String remediationMessage() {
        return this.remediationMessage;
    }

    public final String remediationLink() {
        return this.remediationLink;
    }

    public final AnnotationSeverityLevel severityLevel() {
        return AnnotationSeverityLevel.fromValue(this.severityLevel);
    }

    public final String severityLevelAsString() {
        return this.severityLevel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.annotationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.remediationLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Annotation)) {
            return false;
        }
        Annotation other = (Annotation)obj;
        return Objects.equals(this.annotationName(), other.annotationName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.remediationMessage(), other.remediationMessage()) && Objects.equals(this.remediationLink(), other.remediationLink()) && Objects.equals(this.severityLevelAsString(), other.severityLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Annotation").add("AnnotationName", (Object)this.annotationName()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("RemediationMessage", (Object)this.remediationMessage()).add("RemediationLink", (Object)this.remediationLink()).add("SeverityLevel", (Object)this.severityLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnnotationName": {
                return Optional.ofNullable(clazz.cast(this.annotationName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "RemediationMessage": {
                return Optional.ofNullable(clazz.cast(this.remediationMessage()));
            }
            case "RemediationLink": {
                return Optional.ofNullable(clazz.cast(this.remediationLink()));
            }
            case "SeverityLevel": {
                return Optional.ofNullable(clazz.cast(this.severityLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AnnotationName", ANNOTATION_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("RemediationMessage", REMEDIATION_MESSAGE_FIELD);
        map.put("RemediationLink", REMEDIATION_LINK_FIELD);
        map.put("SeverityLevel", SEVERITY_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Annotation, T> g) {
        return obj -> g.apply((Annotation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String annotationName;
        private String status;
        private String statusMessage;
        private String remediationMessage;
        private String remediationLink;
        private String severityLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(Annotation model) {
            this.annotationName(model.annotationName);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.remediationMessage(model.remediationMessage);
            this.remediationLink(model.remediationLink);
            this.severityLevel(model.severityLevel);
        }

        public final String getAnnotationName() {
            return this.annotationName;
        }

        public final void setAnnotationName(String annotationName) {
            this.annotationName = annotationName;
        }

        @Override
        public final Builder annotationName(String annotationName) {
            this.annotationName = annotationName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnnotationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getRemediationMessage() {
            return this.remediationMessage;
        }

        public final void setRemediationMessage(String remediationMessage) {
            this.remediationMessage = remediationMessage;
        }

        @Override
        public final Builder remediationMessage(String remediationMessage) {
            this.remediationMessage = remediationMessage;
            return this;
        }

        public final String getRemediationLink() {
            return this.remediationLink;
        }

        public final void setRemediationLink(String remediationLink) {
            this.remediationLink = remediationLink;
        }

        @Override
        public final Builder remediationLink(String remediationLink) {
            this.remediationLink = remediationLink;
            return this;
        }

        public final String getSeverityLevel() {
            return this.severityLevel;
        }

        public final void setSeverityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
        }

        @Override
        public final Builder severityLevel(String severityLevel) {
            this.severityLevel = severityLevel;
            return this;
        }

        @Override
        public final Builder severityLevel(AnnotationSeverityLevel severityLevel) {
            this.severityLevel(severityLevel == null ? null : severityLevel.toString());
            return this;
        }

        public Annotation build() {
            return new Annotation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Annotation> {
        public Builder annotationName(String var1);

        public Builder status(String var1);

        public Builder status(AnnotationStatus var1);

        public Builder statusMessage(String var1);

        public Builder remediationMessage(String var1);

        public Builder remediationLink(String var1);

        public Builder severityLevel(String var1);

        public Builder severityLevel(AnnotationSeverityLevel var1);
    }
}

