/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackInstanceResourceDriftsRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListStackInstanceResourceDriftsRequest.Builder, ListStackInstanceResourceDriftsRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackSetName").getter(getter(ListStackInstanceResourceDriftsRequest::stackSetName))
            .setter(setter(Builder::stackSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStackInstanceResourceDriftsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStackInstanceResourceDriftsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<List<String>> STACK_INSTANCE_RESOURCE_DRIFT_STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StackInstanceResourceDriftStatuses")
            .getter(getter(ListStackInstanceResourceDriftsRequest::stackInstanceResourceDriftStatusesAsStrings))
            .setter(setter(Builder::stackInstanceResourceDriftStatusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceResourceDriftStatuses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STACK_INSTANCE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackInstanceAccount").getter(getter(ListStackInstanceResourceDriftsRequest::stackInstanceAccount))
            .setter(setter(Builder::stackInstanceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceAccount").build())
            .build();

    private static final SdkField<String> STACK_INSTANCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackInstanceRegion").getter(getter(ListStackInstanceResourceDriftsRequest::stackInstanceRegion))
            .setter(setter(Builder::stackInstanceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackInstanceRegion").build())
            .build();

    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperationId").getter(getter(ListStackInstanceResourceDriftsRequest::operationId))
            .setter(setter(Builder::operationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()).build();

    private static final SdkField<String> CALL_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CallAs")
            .getter(getter(ListStackInstanceResourceDriftsRequest::callAsAsString)).setter(setter(Builder::callAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STACK_INSTANCE_RESOURCE_DRIFT_STATUSES_FIELD, STACK_INSTANCE_ACCOUNT_FIELD,
            STACK_INSTANCE_REGION_FIELD, OPERATION_ID_FIELD, CALL_AS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackSetName;

    private final String nextToken;

    private final Integer maxResults;

    private final List<String> stackInstanceResourceDriftStatuses;

    private final String stackInstanceAccount;

    private final String stackInstanceRegion;

    private final String operationId;

    private final String callAs;

    private ListStackInstanceResourceDriftsRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.stackInstanceResourceDriftStatuses = builder.stackInstanceResourceDriftStatuses;
        this.stackInstanceAccount = builder.stackInstanceAccount;
        this.stackInstanceRegion = builder.stackInstanceRegion;
        this.operationId = builder.operationId;
        this.callAs = builder.callAs;
    }

    /**
     * <p>
     * The name or unique ID of the StackSet that you want to list drifted resources for.
     * </p>
     * 
     * @return The name or unique ID of the StackSet that you want to list drifted resources for.
     */
    public final String stackSetName() {
        return stackSetName;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The resource drift status of the stack instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackInstanceResourceDriftStatuses}
     * method.
     * </p>
     * 
     * @return The resource drift status of the stack instance. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETED</code>: The resource differs from its expected template configuration in that the resource
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
     *         </p>
     *         </li>
     */
    public final List<StackResourceDriftStatus> stackInstanceResourceDriftStatuses() {
        return StackResourceDriftStatusFiltersCopier.copyStringToEnum(stackInstanceResourceDriftStatuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the StackInstanceResourceDriftStatuses
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasStackInstanceResourceDriftStatuses() {
        return stackInstanceResourceDriftStatuses != null
                && !(stackInstanceResourceDriftStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource drift status of the stack instance.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has been
     * deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStackInstanceResourceDriftStatuses}
     * method.
     * </p>
     * 
     * @return The resource drift status of the stack instance. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DELETED</code>: The resource differs from its expected template configuration in that the resource
     *         has been deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
     *         </p>
     *         </li>
     */
    public final List<String> stackInstanceResourceDriftStatusesAsStrings() {
        return stackInstanceResourceDriftStatuses;
    }

    /**
     * <p>
     * The name of the Amazon Web Services account that you want to list resource drifts for.
     * </p>
     * 
     * @return The name of the Amazon Web Services account that you want to list resource drifts for.
     */
    public final String stackInstanceAccount() {
        return stackInstanceAccount;
    }

    /**
     * <p>
     * The name of the Region where you want to list resource drifts.
     * </p>
     * 
     * @return The name of the Region where you want to list resource drifts.
     */
    public final String stackInstanceRegion() {
        return stackInstanceRegion;
    }

    /**
     * <p>
     * The unique ID of the drift operation.
     * </p>
     * 
     * @return The unique ID of the drift operation.
     */
    public final String operationId() {
        return operationId;
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final CallAs callAs() {
        return CallAs.fromValue(callAs);
    }

    /**
     * <p>
     * [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's
     * management account or as a delegated administrator in a member account.
     * </p>
     * <p>
     * By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you are signed in to the management account, specify <code>SELF</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     * </p>
     * <p>
     * Your Amazon Web Services account must be registered as a delegated administrator in the management account. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #callAs} will
     * return {@link CallAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #callAsAsString}.
     * </p>
     * 
     * @return [Service-managed permissions] Specifies whether you are acting as an account administrator in the
     *         organization's management account or as a delegated administrator in a member account.</p>
     *         <p>
     *         By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed
     *         permissions.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you are signed in to the management account, specify <code>SELF</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
     *         </p>
     *         <p>
     *         Your Amazon Web Services account must be registered as a delegated administrator in the management
     *         account. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
     *         >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
     *         </p>
     *         </li>
     * @see CallAs
     */
    public final String callAsAsString() {
        return callAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasStackInstanceResourceDriftStatuses() ? stackInstanceResourceDriftStatusesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(stackInstanceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        hashCode = 31 * hashCode + Objects.hashCode(callAsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackInstanceResourceDriftsRequest)) {
            return false;
        }
        ListStackInstanceResourceDriftsRequest other = (ListStackInstanceResourceDriftsRequest) obj;
        return Objects.equals(stackSetName(), other.stackSetName())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && hasStackInstanceResourceDriftStatuses() == other.hasStackInstanceResourceDriftStatuses()
                && Objects.equals(stackInstanceResourceDriftStatusesAsStrings(),
                        other.stackInstanceResourceDriftStatusesAsStrings())
                && Objects.equals(stackInstanceAccount(), other.stackInstanceAccount())
                && Objects.equals(stackInstanceRegion(), other.stackInstanceRegion())
                && Objects.equals(operationId(), other.operationId()) && Objects.equals(callAsAsString(), other.callAsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListStackInstanceResourceDriftsRequest")
                .add("StackSetName", stackSetName())
                .add("NextToken", nextToken())
                .add("MaxResults", maxResults())
                .add("StackInstanceResourceDriftStatuses",
                        hasStackInstanceResourceDriftStatuses() ? stackInstanceResourceDriftStatusesAsStrings() : null)
                .add("StackInstanceAccount", stackInstanceAccount()).add("StackInstanceRegion", stackInstanceRegion())
                .add("OperationId", operationId()).add("CallAs", callAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackSetName":
            return Optional.ofNullable(clazz.cast(stackSetName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "StackInstanceResourceDriftStatuses":
            return Optional.ofNullable(clazz.cast(stackInstanceResourceDriftStatusesAsStrings()));
        case "StackInstanceAccount":
            return Optional.ofNullable(clazz.cast(stackInstanceAccount()));
        case "StackInstanceRegion":
            return Optional.ofNullable(clazz.cast(stackInstanceRegion()));
        case "OperationId":
            return Optional.ofNullable(clazz.cast(operationId()));
        case "CallAs":
            return Optional.ofNullable(clazz.cast(callAsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackSetName", STACK_SET_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("StackInstanceResourceDriftStatuses", STACK_INSTANCE_RESOURCE_DRIFT_STATUSES_FIELD);
        map.put("StackInstanceAccount", STACK_INSTANCE_ACCOUNT_FIELD);
        map.put("StackInstanceRegion", STACK_INSTANCE_REGION_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        map.put("CallAs", CALL_AS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStackInstanceResourceDriftsRequest, T> g) {
        return obj -> g.apply((ListStackInstanceResourceDriftsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListStackInstanceResourceDriftsRequest> {
        /**
         * <p>
         * The name or unique ID of the StackSet that you want to list drifted resources for.
         * </p>
         * 
         * @param stackSetName
         *        The name or unique ID of the StackSet that you want to list drifted resources for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackSetName(String stackSetName);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The resource drift status of the stack instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackInstanceResourceDriftStatuses
         *        The resource drift status of the stack instance. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceResourceDriftStatusesWithStrings(Collection<String> stackInstanceResourceDriftStatuses);

        /**
         * <p>
         * The resource drift status of the stack instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackInstanceResourceDriftStatuses
         *        The resource drift status of the stack instance. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceResourceDriftStatusesWithStrings(String... stackInstanceResourceDriftStatuses);

        /**
         * <p>
         * The resource drift status of the stack instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackInstanceResourceDriftStatuses
         *        The resource drift status of the stack instance. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceResourceDriftStatuses(Collection<StackResourceDriftStatus> stackInstanceResourceDriftStatuses);

        /**
         * <p>
         * The resource drift status of the stack instance.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DELETED</code>: The resource differs from its expected template configuration in that the resource has
         * been deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stackInstanceResourceDriftStatuses
         *        The resource drift status of the stack instance. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DELETED</code>: The resource differs from its expected template configuration in that the
         *        resource has been deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MODIFIED</code>: One or more resource properties differ from their expected template values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_SYNC</code>: The resource's actual configuration matches its expected template configuration.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_CHECKED</code>: CloudFormation doesn't currently return this value.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceResourceDriftStatuses(StackResourceDriftStatus... stackInstanceResourceDriftStatuses);

        /**
         * <p>
         * The name of the Amazon Web Services account that you want to list resource drifts for.
         * </p>
         * 
         * @param stackInstanceAccount
         *        The name of the Amazon Web Services account that you want to list resource drifts for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceAccount(String stackInstanceAccount);

        /**
         * <p>
         * The name of the Region where you want to list resource drifts.
         * </p>
         * 
         * @param stackInstanceRegion
         *        The name of the Region where you want to list resource drifts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackInstanceRegion(String stackInstanceRegion);

        /**
         * <p>
         * The unique ID of the drift operation.
         * </p>
         * 
         * @param operationId
         *        The unique ID of the drift operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(String callAs);

        /**
         * <p>
         * [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         * organization's management account or as a delegated administrator in a member account.
         * </p>
         * <p>
         * By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed
         * permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you are signed in to the management account, specify <code>SELF</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         * </p>
         * <p>
         * Your Amazon Web Services account must be registered as a delegated administrator in the management account.
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         * >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param callAs
         *        [Service-managed permissions] Specifies whether you are acting as an account administrator in the
         *        organization's management account or as a delegated administrator in a member account.</p>
         *        <p>
         *        By default, <code>SELF</code> is specified. Use <code>SELF</code> for StackSets with self-managed
         *        permissions.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you are signed in to the management account, specify <code>SELF</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you are signed in to a delegated administrator account, specify <code>DELEGATED_ADMIN</code>.
         *        </p>
         *        <p>
         *        Your Amazon Web Services account must be registered as a delegated administrator in the management
         *        account. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html"
         *        >Register a delegated administrator</a> in the <i>CloudFormation User Guide</i>.
         *        </p>
         *        </li>
         * @see CallAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CallAs
         */
        Builder callAs(CallAs callAs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String stackSetName;

        private String nextToken;

        private Integer maxResults;

        private List<String> stackInstanceResourceDriftStatuses = DefaultSdkAutoConstructList.getInstance();

        private String stackInstanceAccount;

        private String stackInstanceRegion;

        private String operationId;

        private String callAs;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackInstanceResourceDriftsRequest model) {
            super(model);
            stackSetName(model.stackSetName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            stackInstanceResourceDriftStatusesWithStrings(model.stackInstanceResourceDriftStatuses);
            stackInstanceAccount(model.stackInstanceAccount);
            stackInstanceRegion(model.stackInstanceRegion);
            operationId(model.operationId);
            callAs(model.callAs);
        }

        public final String getStackSetName() {
            return stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getStackInstanceResourceDriftStatuses() {
            if (stackInstanceResourceDriftStatuses instanceof SdkAutoConstructList) {
                return null;
            }
            return stackInstanceResourceDriftStatuses;
        }

        public final void setStackInstanceResourceDriftStatuses(Collection<String> stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatuses = StackResourceDriftStatusFiltersCopier
                    .copy(stackInstanceResourceDriftStatuses);
        }

        @Override
        public final Builder stackInstanceResourceDriftStatusesWithStrings(Collection<String> stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatuses = StackResourceDriftStatusFiltersCopier
                    .copy(stackInstanceResourceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstanceResourceDriftStatusesWithStrings(String... stackInstanceResourceDriftStatuses) {
            stackInstanceResourceDriftStatusesWithStrings(Arrays.asList(stackInstanceResourceDriftStatuses));
            return this;
        }

        @Override
        public final Builder stackInstanceResourceDriftStatuses(
                Collection<StackResourceDriftStatus> stackInstanceResourceDriftStatuses) {
            this.stackInstanceResourceDriftStatuses = StackResourceDriftStatusFiltersCopier
                    .copyEnumToString(stackInstanceResourceDriftStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackInstanceResourceDriftStatuses(StackResourceDriftStatus... stackInstanceResourceDriftStatuses) {
            stackInstanceResourceDriftStatuses(Arrays.asList(stackInstanceResourceDriftStatuses));
            return this;
        }

        public final String getStackInstanceAccount() {
            return stackInstanceAccount;
        }

        public final void setStackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
        }

        @Override
        public final Builder stackInstanceAccount(String stackInstanceAccount) {
            this.stackInstanceAccount = stackInstanceAccount;
            return this;
        }

        public final String getStackInstanceRegion() {
            return stackInstanceRegion;
        }

        public final void setStackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
        }

        @Override
        public final Builder stackInstanceRegion(String stackInstanceRegion) {
            this.stackInstanceRegion = stackInstanceRegion;
            return this;
        }

        public final String getOperationId() {
            return operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final String getCallAs() {
            return callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStackInstanceResourceDriftsRequest build() {
            return new ListStackInstanceResourceDriftsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
