/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Event filter allows you to focus on specific events in an operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventFilter implements SdkPojo, Serializable, ToCopyableBuilder<EventFilter.Builder, EventFilter> {
    private static final SdkField<Boolean> FAILED_EVENTS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FailedEvents").getter(getter(EventFilter::failedEvents)).setter(setter(Builder::failedEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedEvents").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_EVENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean failedEvents;

    private EventFilter(BuilderImpl builder) {
        this.failedEvents = builder.failedEvents;
    }

    /**
     * <p>
     * When set to true, only returns failed events within the operation. This helps quickly identify root causes for a
     * failed operation.
     * </p>
     * 
     * @return When set to true, only returns failed events within the operation. This helps quickly identify root
     *         causes for a failed operation.
     */
    public final Boolean failedEvents() {
        return failedEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedEvents());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventFilter)) {
            return false;
        }
        EventFilter other = (EventFilter) obj;
        return Objects.equals(failedEvents(), other.failedEvents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventFilter").add("FailedEvents", failedEvents()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedEvents":
            return Optional.ofNullable(clazz.cast(failedEvents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailedEvents", FAILED_EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventFilter, T> g) {
        return obj -> g.apply((EventFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventFilter> {
        /**
         * <p>
         * When set to true, only returns failed events within the operation. This helps quickly identify root causes
         * for a failed operation.
         * </p>
         * 
         * @param failedEvents
         *        When set to true, only returns failed events within the operation. This helps quickly identify root
         *        causes for a failed operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedEvents(Boolean failedEvents);
    }

    static final class BuilderImpl implements Builder {
        private Boolean failedEvents;

        private BuilderImpl() {
        }

        private BuilderImpl(EventFilter model) {
            failedEvents(model.failedEvents);
        }

        public final Boolean getFailedEvents() {
            return failedEvents;
        }

        public final void setFailedEvents(Boolean failedEvents) {
            this.failedEvents = failedEvents;
        }

        @Override
        public final Builder failedEvents(Boolean failedEvents) {
            this.failedEvents = failedEvents;
            return this;
        }

        @Override
        public EventFilter build() {
            return new EventFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
