/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.Stack;

public class DescribeStacksPublisher
implements SdkPublisher<DescribeStacksResponse> {
    private final CloudFormationAsyncClient client;
    private final DescribeStacksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStacksPublisher(CloudFormationAsyncClient client, DescribeStacksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStacksPublisher(CloudFormationAsyncClient client, DescribeStacksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStacksResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStacksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Stack> stacks() {
        Function<DescribeStacksResponse, Iterator> getIterator = response -> {
            if (response != null && response.stacks() != null) {
                return response.stacks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeStacksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeStacksResponseFetcher
    implements AsyncPageFetcher<DescribeStacksResponse> {
        private DescribeStacksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeStacksResponse> nextPage(DescribeStacksResponse previousPage) {
            if (previousPage == null) {
                return DescribeStacksPublisher.this.client.describeStacks(DescribeStacksPublisher.this.firstRequest);
            }
            return DescribeStacksPublisher.this.client.describeStacks((DescribeStacksRequest)((Object)DescribeStacksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

