/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartResourceScanResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, StartResourceScanResponse> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceScanId").getter(StartResourceScanResponse.getter(StartResourceScanResponse::resourceScanId)).setter(StartResourceScanResponse.setter(Builder::resourceScanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartResourceScanResponse.memberNameToFieldInitializer();
    private final String resourceScanId;

    private StartResourceScanResponse(BuilderImpl builder) {
        super(builder);
        this.resourceScanId = builder.resourceScanId;
    }

    public final String resourceScanId() {
        return this.resourceScanId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceScanId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartResourceScanResponse)) {
            return false;
        }
        StartResourceScanResponse other = (StartResourceScanResponse)((Object)obj);
        return Objects.equals(this.resourceScanId(), other.resourceScanId());
    }

    public final String toString() {
        return ToString.builder((String)"StartResourceScanResponse").add("ResourceScanId", (Object)this.resourceScanId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceScanId": {
                return Optional.ofNullable(clazz.cast(this.resourceScanId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceScanId", RESOURCE_SCAN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartResourceScanResponse, T> g) {
        return obj -> g.apply((StartResourceScanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String resourceScanId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartResourceScanResponse model) {
            super(model);
            this.resourceScanId(model.resourceScanId);
        }

        public final String getResourceScanId() {
            return this.resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        @Override
        public StartResourceScanResponse build() {
            return new StartResourceScanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartResourceScanResponse> {
        public Builder resourceScanId(String var1);
    }
}

