/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsError;
import software.amazon.awssdk.services.cloudformation.model.BatchDescribeTypeConfigurationsErrorsCopier;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.TypeConfigurationDetails;
import software.amazon.awssdk.services.cloudformation.model.TypeConfigurationDetailsListCopier;
import software.amazon.awssdk.services.cloudformation.model.TypeConfigurationIdentifier;
import software.amazon.awssdk.services.cloudformation.model.UnprocessedTypeConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDescribeTypeConfigurationsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, BatchDescribeTypeConfigurationsResponse> {
    private static final SdkField<List<BatchDescribeTypeConfigurationsError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(BatchDescribeTypeConfigurationsResponse.getter(BatchDescribeTypeConfigurationsResponse::errors)).setter(BatchDescribeTypeConfigurationsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchDescribeTypeConfigurationsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TypeConfigurationIdentifier>> UNPROCESSED_TYPE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedTypeConfigurations").getter(BatchDescribeTypeConfigurationsResponse.getter(BatchDescribeTypeConfigurationsResponse::unprocessedTypeConfigurations)).setter(BatchDescribeTypeConfigurationsResponse.setter(Builder::unprocessedTypeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedTypeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypeConfigurationIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TypeConfigurationDetails>> TYPE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TypeConfigurations").getter(BatchDescribeTypeConfigurationsResponse.getter(BatchDescribeTypeConfigurationsResponse::typeConfigurations)).setter(BatchDescribeTypeConfigurationsResponse.setter(Builder::typeConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypeConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, UNPROCESSED_TYPE_CONFIGURATIONS_FIELD, TYPE_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchDescribeTypeConfigurationsResponse.memberNameToFieldInitializer();
    private final List<BatchDescribeTypeConfigurationsError> errors;
    private final List<TypeConfigurationIdentifier> unprocessedTypeConfigurations;
    private final List<TypeConfigurationDetails> typeConfigurations;

    private BatchDescribeTypeConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.unprocessedTypeConfigurations = builder.unprocessedTypeConfigurations;
        this.typeConfigurations = builder.typeConfigurations;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchDescribeTypeConfigurationsError> errors() {
        return this.errors;
    }

    public final boolean hasUnprocessedTypeConfigurations() {
        return this.unprocessedTypeConfigurations != null && !(this.unprocessedTypeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TypeConfigurationIdentifier> unprocessedTypeConfigurations() {
        return this.unprocessedTypeConfigurations;
    }

    public final boolean hasTypeConfigurations() {
        return this.typeConfigurations != null && !(this.typeConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TypeConfigurationDetails> typeConfigurations() {
        return this.typeConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedTypeConfigurations() ? this.unprocessedTypeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypeConfigurations() ? this.typeConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeTypeConfigurationsResponse)) {
            return false;
        }
        BatchDescribeTypeConfigurationsResponse other = (BatchDescribeTypeConfigurationsResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasUnprocessedTypeConfigurations() == other.hasUnprocessedTypeConfigurations() && Objects.equals(this.unprocessedTypeConfigurations(), other.unprocessedTypeConfigurations()) && this.hasTypeConfigurations() == other.hasTypeConfigurations() && Objects.equals(this.typeConfigurations(), other.typeConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"BatchDescribeTypeConfigurationsResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("UnprocessedTypeConfigurations", this.hasUnprocessedTypeConfigurations() ? this.unprocessedTypeConfigurations() : null).add("TypeConfigurations", this.hasTypeConfigurations() ? this.typeConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "UnprocessedTypeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.unprocessedTypeConfigurations()));
            }
            case "TypeConfigurations": {
                return Optional.ofNullable(clazz.cast(this.typeConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Errors", ERRORS_FIELD);
        map.put("UnprocessedTypeConfigurations", UNPROCESSED_TYPE_CONFIGURATIONS_FIELD);
        map.put("TypeConfigurations", TYPE_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeTypeConfigurationsResponse, T> g) {
        return obj -> g.apply((BatchDescribeTypeConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<BatchDescribeTypeConfigurationsError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<TypeConfigurationIdentifier> unprocessedTypeConfigurations = DefaultSdkAutoConstructList.getInstance();
        private List<TypeConfigurationDetails> typeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeTypeConfigurationsResponse model) {
            super(model);
            this.errors(model.errors);
            this.unprocessedTypeConfigurations(model.unprocessedTypeConfigurations);
            this.typeConfigurations(model.typeConfigurations);
        }

        public final List<BatchDescribeTypeConfigurationsError.Builder> getErrors() {
            List<BatchDescribeTypeConfigurationsError.Builder> result = BatchDescribeTypeConfigurationsErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchDescribeTypeConfigurationsError.BuilderImpl> errors) {
            this.errors = BatchDescribeTypeConfigurationsErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchDescribeTypeConfigurationsError> errors) {
            this.errors = BatchDescribeTypeConfigurationsErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchDescribeTypeConfigurationsError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchDescribeTypeConfigurationsError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchDescribeTypeConfigurationsError)((BatchDescribeTypeConfigurationsError.Builder)BatchDescribeTypeConfigurationsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TypeConfigurationIdentifier.Builder> getUnprocessedTypeConfigurations() {
            List<TypeConfigurationIdentifier.Builder> result = UnprocessedTypeConfigurationsCopier.copyToBuilder(this.unprocessedTypeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedTypeConfigurations(Collection<TypeConfigurationIdentifier.BuilderImpl> unprocessedTypeConfigurations) {
            this.unprocessedTypeConfigurations = UnprocessedTypeConfigurationsCopier.copyFromBuilder(unprocessedTypeConfigurations);
        }

        @Override
        public final Builder unprocessedTypeConfigurations(Collection<TypeConfigurationIdentifier> unprocessedTypeConfigurations) {
            this.unprocessedTypeConfigurations = UnprocessedTypeConfigurationsCopier.copy(unprocessedTypeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTypeConfigurations(TypeConfigurationIdentifier ... unprocessedTypeConfigurations) {
            this.unprocessedTypeConfigurations(Arrays.asList(unprocessedTypeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedTypeConfigurations(Consumer<TypeConfigurationIdentifier.Builder> ... unprocessedTypeConfigurations) {
            this.unprocessedTypeConfigurations(Stream.of(unprocessedTypeConfigurations).map(c -> (TypeConfigurationIdentifier)((TypeConfigurationIdentifier.Builder)TypeConfigurationIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TypeConfigurationDetails.Builder> getTypeConfigurations() {
            List<TypeConfigurationDetails.Builder> result = TypeConfigurationDetailsListCopier.copyToBuilder(this.typeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypeConfigurations(Collection<TypeConfigurationDetails.BuilderImpl> typeConfigurations) {
            this.typeConfigurations = TypeConfigurationDetailsListCopier.copyFromBuilder(typeConfigurations);
        }

        @Override
        public final Builder typeConfigurations(Collection<TypeConfigurationDetails> typeConfigurations) {
            this.typeConfigurations = TypeConfigurationDetailsListCopier.copy(typeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeConfigurations(TypeConfigurationDetails ... typeConfigurations) {
            this.typeConfigurations(Arrays.asList(typeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeConfigurations(Consumer<TypeConfigurationDetails.Builder> ... typeConfigurations) {
            this.typeConfigurations(Stream.of(typeConfigurations).map(c -> (TypeConfigurationDetails)((TypeConfigurationDetails.Builder)TypeConfigurationDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDescribeTypeConfigurationsResponse build() {
            return new BatchDescribeTypeConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchDescribeTypeConfigurationsResponse> {
        public Builder errors(Collection<BatchDescribeTypeConfigurationsError> var1);

        public Builder errors(BatchDescribeTypeConfigurationsError ... var1);

        public Builder errors(Consumer<BatchDescribeTypeConfigurationsError.Builder> ... var1);

        public Builder unprocessedTypeConfigurations(Collection<TypeConfigurationIdentifier> var1);

        public Builder unprocessedTypeConfigurations(TypeConfigurationIdentifier ... var1);

        public Builder unprocessedTypeConfigurations(Consumer<TypeConfigurationIdentifier.Builder> ... var1);

        public Builder typeConfigurations(Collection<TypeConfigurationDetails> var1);

        public Builder typeConfigurations(TypeConfigurationDetails ... var1);

        public Builder typeConfigurations(Consumer<TypeConfigurationDetails.Builder> ... var1);
    }
}

