/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterPublisherRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, RegisterPublisherRequest> {
    private static final SdkField<Boolean> ACCEPT_TERMS_AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AcceptTermsAndConditions").getter(RegisterPublisherRequest.getter(RegisterPublisherRequest::acceptTermsAndConditions)).setter(RegisterPublisherRequest.setter(Builder::acceptTermsAndConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptTermsAndConditions").build()}).build();
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionArn").getter(RegisterPublisherRequest.getter(RegisterPublisherRequest::connectionArn)).setter(RegisterPublisherRequest.setter(Builder::connectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_TERMS_AND_CONDITIONS_FIELD, CONNECTION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AcceptTermsAndConditions", ACCEPT_TERMS_AND_CONDITIONS_FIELD);
            this.put("ConnectionArn", CONNECTION_ARN_FIELD);
        }
    });
    private final Boolean acceptTermsAndConditions;
    private final String connectionArn;

    private RegisterPublisherRequest(BuilderImpl builder) {
        super(builder);
        this.acceptTermsAndConditions = builder.acceptTermsAndConditions;
        this.connectionArn = builder.connectionArn;
    }

    public final Boolean acceptTermsAndConditions() {
        return this.acceptTermsAndConditions;
    }

    public final String connectionArn() {
        return this.connectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptTermsAndConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterPublisherRequest)) {
            return false;
        }
        RegisterPublisherRequest other = (RegisterPublisherRequest)((Object)obj);
        return Objects.equals(this.acceptTermsAndConditions(), other.acceptTermsAndConditions()) && Objects.equals(this.connectionArn(), other.connectionArn());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterPublisherRequest").add("AcceptTermsAndConditions", (Object)this.acceptTermsAndConditions()).add("ConnectionArn", (Object)this.connectionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptTermsAndConditions": {
                return Optional.ofNullable(clazz.cast(this.acceptTermsAndConditions()));
            }
            case "ConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.connectionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RegisterPublisherRequest, T> g) {
        return obj -> g.apply((RegisterPublisherRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private Boolean acceptTermsAndConditions;
        private String connectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterPublisherRequest model) {
            super(model);
            this.acceptTermsAndConditions(model.acceptTermsAndConditions);
            this.connectionArn(model.connectionArn);
        }

        public final Boolean getAcceptTermsAndConditions() {
            return this.acceptTermsAndConditions;
        }

        public final void setAcceptTermsAndConditions(Boolean acceptTermsAndConditions) {
            this.acceptTermsAndConditions = acceptTermsAndConditions;
        }

        @Override
        public final Builder acceptTermsAndConditions(Boolean acceptTermsAndConditions) {
            this.acceptTermsAndConditions = acceptTermsAndConditions;
            return this;
        }

        public final String getConnectionArn() {
            return this.connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterPublisherRequest build() {
            return new RegisterPublisherRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterPublisherRequest> {
        public Builder acceptTermsAndConditions(Boolean var1);

        public Builder connectionArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

