/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HookStatus {
    HOOK_IN_PROGRESS("HOOK_IN_PROGRESS"),
    HOOK_COMPLETE_SUCCEEDED("HOOK_COMPLETE_SUCCEEDED"),
    HOOK_COMPLETE_FAILED("HOOK_COMPLETE_FAILED"),
    HOOK_FAILED("HOOK_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HookStatus> VALUE_MAP;
    private final String value;

    private HookStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HookStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HookStatus> knownValues() {
        EnumSet<HookStatus> knownValues = EnumSet.allOf(HookStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HookStatus.class, HookStatus::toString);
    }
}

