/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeRegistrationsResponse;

public class ListTypeRegistrationsIterable
implements SdkIterable<ListTypeRegistrationsResponse> {
    private final CloudFormationClient client;
    private final ListTypeRegistrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypeRegistrationsIterable(CloudFormationClient client, ListTypeRegistrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTypeRegistrationsResponseFetcher();
    }

    public Iterator<ListTypeRegistrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTypeRegistrationsResponseFetcher
    implements SyncPageFetcher<ListTypeRegistrationsResponse> {
        private ListTypeRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTypeRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTypeRegistrationsResponse nextPage(ListTypeRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return ListTypeRegistrationsIterable.this.client.listTypeRegistrations(ListTypeRegistrationsIterable.this.firstRequest);
            }
            return ListTypeRegistrationsIterable.this.client.listTypeRegistrations((ListTypeRegistrationsRequest)((Object)ListTypeRegistrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

