/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListTypesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypesResponse;
import software.amazon.awssdk.services.cloudformation.model.TypeSummary;

public class ListTypesIterable
implements SdkIterable<ListTypesResponse> {
    private final CloudFormationClient client;
    private final ListTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypesIterable(CloudFormationClient client, ListTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTypesResponseFetcher();
    }

    public Iterator<ListTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TypeSummary> typeSummaries() {
        Function<ListTypesResponse, Iterator> getIterator = response -> {
            if (response != null && response.typeSummaries() != null) {
                return response.typeSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTypesResponseFetcher
    implements SyncPageFetcher<ListTypesResponse> {
        private ListTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTypesResponse nextPage(ListTypesResponse previousPage) {
            if (previousPage == null) {
                return ListTypesIterable.this.client.listTypes(ListTypesIterable.this.firstRequest);
            }
            return ListTypesIterable.this.client.listTypes((ListTypesRequest)((Object)ListTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

