/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListTypeVersionsResponse;

public class ListTypeVersionsPublisher
implements SdkPublisher<ListTypeVersionsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListTypeVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTypeVersionsPublisher(CloudFormationAsyncClient client, ListTypeVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTypeVersionsPublisher(CloudFormationAsyncClient client, ListTypeVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTypeVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTypeVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTypeVersionsResponseFetcher
    implements AsyncPageFetcher<ListTypeVersionsResponse> {
        private ListTypeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTypeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTypeVersionsResponse> nextPage(ListTypeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListTypeVersionsPublisher.this.client.listTypeVersions(ListTypeVersionsPublisher.this.firstRequest);
            }
            return ListTypeVersionsPublisher.this.client.listTypeVersions((ListTypeVersionsRequest)((Object)ListTypeVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

