/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ModuleInfo;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackResource> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(StackResource.getter(StackResource::stackName)).setter(StackResource.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(StackResource.getter(StackResource::stackId)).setter(StackResource.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalResourceId").getter(StackResource.getter(StackResource::logicalResourceId)).setter(StackResource.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<String> PHYSICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhysicalResourceId").getter(StackResource.getter(StackResource::physicalResourceId)).setter(StackResource.setter(Builder::physicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhysicalResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(StackResource.getter(StackResource::resourceType)).setter(StackResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(StackResource.getter(StackResource::timestamp)).setter(StackResource.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatus").getter(StackResource.getter(StackResource::resourceStatusAsString)).setter(StackResource.setter(Builder::resourceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatus").build()}).build();
    private static final SdkField<String> RESOURCE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceStatusReason").getter(StackResource.getter(StackResource::resourceStatusReason)).setter(StackResource.setter(Builder::resourceStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceStatusReason").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StackResource.getter(StackResource::description)).setter(StackResource.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<StackResourceDriftInformation> DRIFT_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DriftInformation").getter(StackResource.getter(StackResource::driftInformation)).setter(StackResource.setter(Builder::driftInformation)).constructor(StackResourceDriftInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriftInformation").build()}).build();
    private static final SdkField<ModuleInfo> MODULE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModuleInfo").getter(StackResource.getter(StackResource::moduleInfo)).setter(StackResource.setter(Builder::moduleInfo)).constructor(ModuleInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModuleInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, STACK_ID_FIELD, LOGICAL_RESOURCE_ID_FIELD, PHYSICAL_RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, TIMESTAMP_FIELD, RESOURCE_STATUS_FIELD, RESOURCE_STATUS_REASON_FIELD, DESCRIPTION_FIELD, DRIFT_INFORMATION_FIELD, MODULE_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackName;
    private final String stackId;
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Instant timestamp;
    private final String resourceStatus;
    private final String resourceStatusReason;
    private final String description;
    private final StackResourceDriftInformation driftInformation;
    private final ModuleInfo moduleInfo;

    private StackResource(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.stackId = builder.stackId;
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.timestamp = builder.timestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
        this.description = builder.description;
        this.driftInformation = builder.driftInformation;
        this.moduleInfo = builder.moduleInfo;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String logicalResourceId() {
        return this.logicalResourceId;
    }

    public final String physicalResourceId() {
        return this.physicalResourceId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public final String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public final String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public final String description() {
        return this.description;
    }

    public final StackResourceDriftInformation driftInformation() {
        return this.driftInformation;
    }

    public final ModuleInfo moduleInfo() {
        return this.moduleInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.driftInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.moduleInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResource)) {
            return false;
        }
        StackResource other = (StackResource)obj;
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.resourceStatusReason(), other.resourceStatusReason()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.driftInformation(), other.driftInformation()) && Objects.equals(this.moduleInfo(), other.moduleInfo());
    }

    public final String toString() {
        return ToString.builder((String)"StackResource").add("StackName", (Object)this.stackName()).add("StackId", (Object)this.stackId()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("Timestamp", (Object)this.timestamp()).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ResourceStatusReason", (Object)this.resourceStatusReason()).add("Description", (Object)this.description()).add("DriftInformation", (Object)this.driftInformation()).add("ModuleInfo", (Object)this.moduleInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "ResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusAsString()));
            }
            case "ResourceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusReason()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DriftInformation": {
                return Optional.ofNullable(clazz.cast(this.driftInformation()));
            }
            case "ModuleInfo": {
                return Optional.ofNullable(clazz.cast(this.moduleInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackResource, T> g) {
        return obj -> g.apply((StackResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String stackId;
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Instant timestamp;
        private String resourceStatus;
        private String resourceStatusReason;
        private String description;
        private StackResourceDriftInformation driftInformation;
        private ModuleInfo moduleInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResource model) {
            this.stackName(model.stackName);
            this.stackId(model.stackId);
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.timestamp(model.timestamp);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
            this.description(model.description);
            this.driftInformation(model.driftInformation);
            this.moduleInfo(model.moduleInfo);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        @Transient
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        @Transient
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        @Override
        @Transient
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        @Override
        @Transient
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        @Transient
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        @Override
        @Transient
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus == null ? null : resourceStatus.toString());
            return this;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        @Override
        @Transient
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final StackResourceDriftInformation.Builder getDriftInformation() {
            return this.driftInformation != null ? this.driftInformation.toBuilder() : null;
        }

        public final void setDriftInformation(StackResourceDriftInformation.BuilderImpl driftInformation) {
            this.driftInformation = driftInformation != null ? driftInformation.build() : null;
        }

        @Override
        @Transient
        public final Builder driftInformation(StackResourceDriftInformation driftInformation) {
            this.driftInformation = driftInformation;
            return this;
        }

        public final ModuleInfo.Builder getModuleInfo() {
            return this.moduleInfo != null ? this.moduleInfo.toBuilder() : null;
        }

        public final void setModuleInfo(ModuleInfo.BuilderImpl moduleInfo) {
            this.moduleInfo = moduleInfo != null ? moduleInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder moduleInfo(ModuleInfo moduleInfo) {
            this.moduleInfo = moduleInfo;
            return this;
        }

        public StackResource build() {
            return new StackResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackResource> {
        public Builder stackName(String var1);

        public Builder stackId(String var1);

        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder timestamp(Instant var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);

        public Builder description(String var1);

        public Builder driftInformation(StackResourceDriftInformation var1);

        default public Builder driftInformation(Consumer<StackResourceDriftInformation.Builder> driftInformation) {
            return this.driftInformation((StackResourceDriftInformation)((StackResourceDriftInformation.Builder)StackResourceDriftInformation.builder().applyMutation(driftInformation)).build());
        }

        public Builder moduleInfo(ModuleInfo var1);

        default public Builder moduleInfo(Consumer<ModuleInfo.Builder> moduleInfo) {
            return this.moduleInfo((ModuleInfo)((ModuleInfo.Builder)ModuleInfo.builder().applyMutation(moduleInfo)).build());
        }
    }
}

