/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Category {
    REGISTERED("REGISTERED"),
    ACTIVATED("ACTIVATED"),
    THIRD_PARTY("THIRD_PARTY"),
    AWS_TYPES("AWS_TYPES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Category> VALUE_MAP;
    private final String value;

    private Category(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Category fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Category> knownValues() {
        EnumSet<Category> knownValues = EnumSet.allOf(Category.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Category.class, Category::toString);
    }
}

