/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.StackDriftStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackDriftInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackDriftInformation> {
    private static final SdkField<String> STACK_DRIFT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackDriftStatus").getter(StackDriftInformation.getter(StackDriftInformation::stackDriftStatusAsString)).setter(StackDriftInformation.setter(Builder::stackDriftStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackDriftStatus").build()}).build();
    private static final SdkField<Instant> LAST_CHECK_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCheckTimestamp").getter(StackDriftInformation.getter(StackDriftInformation::lastCheckTimestamp)).setter(StackDriftInformation.setter(Builder::lastCheckTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCheckTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_DRIFT_STATUS_FIELD, LAST_CHECK_TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackDriftStatus;
    private final Instant lastCheckTimestamp;

    private StackDriftInformation(BuilderImpl builder) {
        this.stackDriftStatus = builder.stackDriftStatus;
        this.lastCheckTimestamp = builder.lastCheckTimestamp;
    }

    public final StackDriftStatus stackDriftStatus() {
        return StackDriftStatus.fromValue(this.stackDriftStatus);
    }

    public final String stackDriftStatusAsString() {
        return this.stackDriftStatus;
    }

    public final Instant lastCheckTimestamp() {
        return this.lastCheckTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackDriftStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCheckTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackDriftInformation)) {
            return false;
        }
        StackDriftInformation other = (StackDriftInformation)obj;
        return Objects.equals(this.stackDriftStatusAsString(), other.stackDriftStatusAsString()) && Objects.equals(this.lastCheckTimestamp(), other.lastCheckTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"StackDriftInformation").add("StackDriftStatus", (Object)this.stackDriftStatusAsString()).add("LastCheckTimestamp", (Object)this.lastCheckTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackDriftStatus": {
                return Optional.ofNullable(clazz.cast(this.stackDriftStatusAsString()));
            }
            case "LastCheckTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastCheckTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StackDriftInformation, T> g) {
        return obj -> g.apply((StackDriftInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackDriftStatus;
        private Instant lastCheckTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackDriftInformation model) {
            this.stackDriftStatus(model.stackDriftStatus);
            this.lastCheckTimestamp(model.lastCheckTimestamp);
        }

        public final String getStackDriftStatus() {
            return this.stackDriftStatus;
        }

        @Override
        public final Builder stackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
            return this;
        }

        @Override
        public final Builder stackDriftStatus(StackDriftStatus stackDriftStatus) {
            this.stackDriftStatus(stackDriftStatus == null ? null : stackDriftStatus.toString());
            return this;
        }

        public final void setStackDriftStatus(String stackDriftStatus) {
            this.stackDriftStatus = stackDriftStatus;
        }

        public final Instant getLastCheckTimestamp() {
            return this.lastCheckTimestamp;
        }

        @Override
        public final Builder lastCheckTimestamp(Instant lastCheckTimestamp) {
            this.lastCheckTimestamp = lastCheckTimestamp;
            return this;
        }

        public final void setLastCheckTimestamp(Instant lastCheckTimestamp) {
            this.lastCheckTimestamp = lastCheckTimestamp;
        }

        public StackDriftInformation build() {
            return new StackDriftInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackDriftInformation> {
        public Builder stackDriftStatus(String var1);

        public Builder stackDriftStatus(StackDriftStatus var1);

        public Builder lastCheckTimestamp(Instant var1);
    }
}

