/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HandlerErrorCode {
    NOT_UPDATABLE("NotUpdatable"),
    INVALID_REQUEST("InvalidRequest"),
    ACCESS_DENIED("AccessDenied"),
    INVALID_CREDENTIALS("InvalidCredentials"),
    ALREADY_EXISTS("AlreadyExists"),
    NOT_FOUND("NotFound"),
    RESOURCE_CONFLICT("ResourceConflict"),
    THROTTLING("Throttling"),
    SERVICE_LIMIT_EXCEEDED("ServiceLimitExceeded"),
    NOT_STABILIZED("NotStabilized"),
    GENERAL_SERVICE_EXCEPTION("GeneralServiceException"),
    SERVICE_INTERNAL_ERROR("ServiceInternalError"),
    NETWORK_FAILURE("NetworkFailure"),
    INTERNAL_FAILURE("InternalFailure"),
    INVALID_TYPE_CONFIGURATION("InvalidTypeConfiguration"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HandlerErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HandlerErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HandlerErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HandlerErrorCode> knownValues() {
        return Stream.of(HandlerErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

