/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.LoggingConfig;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTypeRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, RegisterTypeRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RegisterTypeRequest.getter(RegisterTypeRequest::typeAsString)).setter(RegisterTypeRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(RegisterTypeRequest.getter(RegisterTypeRequest::typeName)).setter(RegisterTypeRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> SCHEMA_HANDLER_PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaHandlerPackage").getter(RegisterTypeRequest.getter(RegisterTypeRequest::schemaHandlerPackage)).setter(RegisterTypeRequest.setter(Builder::schemaHandlerPackage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaHandlerPackage").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfig").getter(RegisterTypeRequest.getter(RegisterTypeRequest::loggingConfig)).setter(RegisterTypeRequest.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(RegisterTypeRequest.getter(RegisterTypeRequest::executionRoleArn)).setter(RegisterTypeRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(RegisterTypeRequest.getter(RegisterTypeRequest::clientRequestToken)).setter(RegisterTypeRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD, SCHEMA_HANDLER_PACKAGE_FIELD, LOGGING_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String type;
    private final String typeName;
    private final String schemaHandlerPackage;
    private final LoggingConfig loggingConfig;
    private final String executionRoleArn;
    private final String clientRequestToken;

    private RegisterTypeRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.schemaHandlerPackage = builder.schemaHandlerPackage;
        this.loggingConfig = builder.loggingConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String schemaHandlerPackage() {
        return this.schemaHandlerPackage;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaHandlerPackage());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTypeRequest)) {
            return false;
        }
        RegisterTypeRequest other = (RegisterTypeRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.schemaHandlerPackage(), other.schemaHandlerPackage()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterTypeRequest").add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("SchemaHandlerPackage", (Object)this.schemaHandlerPackage()).add("LoggingConfig", (Object)this.loggingConfig()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "SchemaHandlerPackage": {
                return Optional.ofNullable(clazz.cast(this.schemaHandlerPackage()));
            }
            case "LoggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTypeRequest, T> g) {
        return obj -> g.apply((RegisterTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String type;
        private String typeName;
        private String schemaHandlerPackage;
        private LoggingConfig loggingConfig;
        private String executionRoleArn;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTypeRequest model) {
            super(model);
            this.type(model.type);
            this.typeName(model.typeName);
            this.schemaHandlerPackage(model.schemaHandlerPackage);
            this.loggingConfig(model.loggingConfig);
            this.executionRoleArn(model.executionRoleArn);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getSchemaHandlerPackage() {
            return this.schemaHandlerPackage;
        }

        @Override
        public final Builder schemaHandlerPackage(String schemaHandlerPackage) {
            this.schemaHandlerPackage = schemaHandlerPackage;
            return this;
        }

        public final void setSchemaHandlerPackage(String schemaHandlerPackage) {
            this.schemaHandlerPackage = schemaHandlerPackage;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTypeRequest build() {
            return new RegisterTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTypeRequest> {
        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder schemaHandlerPackage(String var1);

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

