/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.Category;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypeFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypeFilters> {
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(TypeFilters.getter(TypeFilters::categoryAsString)).setter(TypeFilters.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherId").getter(TypeFilters.getter(TypeFilters::publisherId)).setter(TypeFilters.setter(Builder::publisherId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()}).build();
    private static final SdkField<String> TYPE_NAME_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeNamePrefix").getter(TypeFilters.getter(TypeFilters::typeNamePrefix)).setter(TypeFilters.setter(Builder::typeNamePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeNamePrefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_FIELD, PUBLISHER_ID_FIELD, TYPE_NAME_PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String category;
    private final String publisherId;
    private final String typeNamePrefix;

    private TypeFilters(BuilderImpl builder) {
        this.category = builder.category;
        this.publisherId = builder.publisherId;
        this.typeNamePrefix = builder.typeNamePrefix;
    }

    public final Category category() {
        return Category.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final String publisherId() {
        return this.publisherId;
    }

    public final String typeNamePrefix() {
        return this.typeNamePrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeNamePrefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeFilters)) {
            return false;
        }
        TypeFilters other = (TypeFilters)obj;
        return Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.publisherId(), other.publisherId()) && Objects.equals(this.typeNamePrefix(), other.typeNamePrefix());
    }

    public final String toString() {
        return ToString.builder((String)"TypeFilters").add("Category", (Object)this.categoryAsString()).add("PublisherId", (Object)this.publisherId()).add("TypeNamePrefix", (Object)this.typeNamePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "PublisherId": {
                return Optional.ofNullable(clazz.cast(this.publisherId()));
            }
            case "TypeNamePrefix": {
                return Optional.ofNullable(clazz.cast(this.typeNamePrefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypeFilters, T> g) {
        return obj -> g.apply((TypeFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String category;
        private String publisherId;
        private String typeNamePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(TypeFilters model) {
            this.category(model.category);
            this.publisherId(model.publisherId);
            this.typeNamePrefix(model.typeNamePrefix);
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(Category category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final String getPublisherId() {
            return this.publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        public final String getTypeNamePrefix() {
            return this.typeNamePrefix;
        }

        @Override
        public final Builder typeNamePrefix(String typeNamePrefix) {
            this.typeNamePrefix = typeNamePrefix;
            return this;
        }

        public final void setTypeNamePrefix(String typeNamePrefix) {
            this.typeNamePrefix = typeNamePrefix;
        }

        public TypeFilters build() {
            return new TypeFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypeFilters> {
        public Builder category(String var1);

        public Builder category(Category var1);

        public Builder publisherId(String var1);

        public Builder typeNamePrefix(String var1);
    }
}

