/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModuleInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModuleInfo> {
    private static final SdkField<String> TYPE_HIERARCHY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeHierarchy").getter(ModuleInfo.getter(ModuleInfo::typeHierarchy)).setter(ModuleInfo.setter(Builder::typeHierarchy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeHierarchy").build()}).build();
    private static final SdkField<String> LOGICAL_ID_HIERARCHY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalIdHierarchy").getter(ModuleInfo.getter(ModuleInfo::logicalIdHierarchy)).setter(ModuleInfo.setter(Builder::logicalIdHierarchy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalIdHierarchy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_HIERARCHY_FIELD, LOGICAL_ID_HIERARCHY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String typeHierarchy;
    private final String logicalIdHierarchy;

    private ModuleInfo(BuilderImpl builder) {
        this.typeHierarchy = builder.typeHierarchy;
        this.logicalIdHierarchy = builder.logicalIdHierarchy;
    }

    public String typeHierarchy() {
        return this.typeHierarchy;
    }

    public String logicalIdHierarchy() {
        return this.logicalIdHierarchy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeHierarchy());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalIdHierarchy());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleInfo)) {
            return false;
        }
        ModuleInfo other = (ModuleInfo)obj;
        return Objects.equals(this.typeHierarchy(), other.typeHierarchy()) && Objects.equals(this.logicalIdHierarchy(), other.logicalIdHierarchy());
    }

    public String toString() {
        return ToString.builder((String)"ModuleInfo").add("TypeHierarchy", (Object)this.typeHierarchy()).add("LogicalIdHierarchy", (Object)this.logicalIdHierarchy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeHierarchy": {
                return Optional.ofNullable(clazz.cast(this.typeHierarchy()));
            }
            case "LogicalIdHierarchy": {
                return Optional.ofNullable(clazz.cast(this.logicalIdHierarchy()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModuleInfo, T> g) {
        return obj -> g.apply((ModuleInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeHierarchy;
        private String logicalIdHierarchy;

        private BuilderImpl() {
        }

        private BuilderImpl(ModuleInfo model) {
            this.typeHierarchy(model.typeHierarchy);
            this.logicalIdHierarchy(model.logicalIdHierarchy);
        }

        public final String getTypeHierarchy() {
            return this.typeHierarchy;
        }

        @Override
        public final Builder typeHierarchy(String typeHierarchy) {
            this.typeHierarchy = typeHierarchy;
            return this;
        }

        public final void setTypeHierarchy(String typeHierarchy) {
            this.typeHierarchy = typeHierarchy;
        }

        public final String getLogicalIdHierarchy() {
            return this.logicalIdHierarchy;
        }

        @Override
        public final Builder logicalIdHierarchy(String logicalIdHierarchy) {
            this.logicalIdHierarchy = logicalIdHierarchy;
            return this;
        }

        public final void setLogicalIdHierarchy(String logicalIdHierarchy) {
            this.logicalIdHierarchy = logicalIdHierarchy;
        }

        public ModuleInfo build() {
            return new ModuleInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModuleInfo> {
        public Builder typeHierarchy(String var1);

        public Builder logicalIdHierarchy(String var1);
    }
}

