/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStackRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, UpdateStackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(UpdateStackRequest.getter(UpdateStackRequest::stackName)).setter(UpdateStackRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(UpdateStackRequest.getter(UpdateStackRequest::templateBody)).setter(UpdateStackRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateURL").getter(UpdateStackRequest.getter(UpdateStackRequest::templateURL)).setter(UpdateStackRequest.setter(Builder::templateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()}).build();
    private static final SdkField<Boolean> USE_PREVIOUS_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UsePreviousTemplate").getter(UpdateStackRequest.getter(UpdateStackRequest::usePreviousTemplate)).setter(UpdateStackRequest.setter(Builder::usePreviousTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousTemplate").build()}).build();
    private static final SdkField<String> STACK_POLICY_DURING_UPDATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackPolicyDuringUpdateBody").getter(UpdateStackRequest.getter(UpdateStackRequest::stackPolicyDuringUpdateBody)).setter(UpdateStackRequest.setter(Builder::stackPolicyDuringUpdateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyDuringUpdateBody").build()}).build();
    private static final SdkField<String> STACK_POLICY_DURING_UPDATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackPolicyDuringUpdateURL").getter(UpdateStackRequest.getter(UpdateStackRequest::stackPolicyDuringUpdateURL)).setter(UpdateStackRequest.setter(Builder::stackPolicyDuringUpdateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyDuringUpdateURL").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(UpdateStackRequest.getter(UpdateStackRequest::parameters)).setter(UpdateStackRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(UpdateStackRequest.getter(UpdateStackRequest::capabilitiesAsStrings)).setter(UpdateStackRequest.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTypes").getter(UpdateStackRequest.getter(UpdateStackRequest::resourceTypes)).setter(UpdateStackRequest.setter(Builder::resourceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleARN").getter(UpdateStackRequest.getter(UpdateStackRequest::roleARN)).setter(UpdateStackRequest.setter(Builder::roleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()}).build();
    private static final SdkField<RollbackConfiguration> ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RollbackConfiguration").getter(UpdateStackRequest.getter(UpdateStackRequest::rollbackConfiguration)).setter(UpdateStackRequest.setter(Builder::rollbackConfiguration)).constructor(RollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollbackConfiguration").build()}).build();
    private static final SdkField<String> STACK_POLICY_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackPolicyBody").getter(UpdateStackRequest.getter(UpdateStackRequest::stackPolicyBody)).setter(UpdateStackRequest.setter(Builder::stackPolicyBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyBody").build()}).build();
    private static final SdkField<String> STACK_POLICY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackPolicyURL").getter(UpdateStackRequest.getter(UpdateStackRequest::stackPolicyURL)).setter(UpdateStackRequest.setter(Builder::stackPolicyURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackPolicyURL").build()}).build();
    private static final SdkField<List<String>> NOTIFICATION_AR_NS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotificationARNs").getter(UpdateStackRequest.getter(UpdateStackRequest::notificationARNs)).setter(UpdateStackRequest.setter(Builder::notificationARNs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationARNs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(UpdateStackRequest.getter(UpdateStackRequest::tags)).setter(UpdateStackRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(UpdateStackRequest.getter(UpdateStackRequest::clientRequestToken)).setter(UpdateStackRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, USE_PREVIOUS_TEMPLATE_FIELD, STACK_POLICY_DURING_UPDATE_BODY_FIELD, STACK_POLICY_DURING_UPDATE_URL_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD, RESOURCE_TYPES_FIELD, ROLE_ARN_FIELD, ROLLBACK_CONFIGURATION_FIELD, STACK_POLICY_BODY_FIELD, STACK_POLICY_URL_FIELD, NOTIFICATION_AR_NS_FIELD, TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private final String stackName;
    private final String templateBody;
    private final String templateURL;
    private final Boolean usePreviousTemplate;
    private final String stackPolicyDuringUpdateBody;
    private final String stackPolicyDuringUpdateURL;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<String> resourceTypes;
    private final String roleARN;
    private final RollbackConfiguration rollbackConfiguration;
    private final String stackPolicyBody;
    private final String stackPolicyURL;
    private final List<String> notificationARNs;
    private final List<Tag> tags;
    private final String clientRequestToken;

    private UpdateStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.stackPolicyDuringUpdateBody = builder.stackPolicyDuringUpdateBody;
        this.stackPolicyDuringUpdateURL = builder.stackPolicyDuringUpdateURL;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.rollbackConfiguration = builder.rollbackConfiguration;
        this.stackPolicyBody = builder.stackPolicyBody;
        this.stackPolicyURL = builder.stackPolicyURL;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateURL() {
        return this.templateURL;
    }

    public Boolean usePreviousTemplate() {
        return this.usePreviousTemplate;
    }

    public String stackPolicyDuringUpdateBody() {
        return this.stackPolicyDuringUpdateBody;
    }

    public String stackPolicyDuringUpdateURL() {
        return this.stackPolicyDuringUpdateURL;
    }

    public boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public boolean hasResourceTypes() {
        return this.resourceTypes != null && !(this.resourceTypes instanceof SdkAutoConstructList);
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public RollbackConfiguration rollbackConfiguration() {
        return this.rollbackConfiguration;
    }

    public String stackPolicyBody() {
        return this.stackPolicyBody;
    }

    public String stackPolicyURL() {
        return this.stackPolicyURL;
    }

    public boolean hasNotificationARNs() {
        return this.notificationARNs != null && !(this.notificationARNs instanceof SdkAutoConstructList);
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePreviousTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyDuringUpdateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyDuringUpdateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackPolicyURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationARNs());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackRequest)) {
            return false;
        }
        UpdateStackRequest other = (UpdateStackRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.usePreviousTemplate(), other.usePreviousTemplate()) && Objects.equals(this.stackPolicyDuringUpdateBody(), other.stackPolicyDuringUpdateBody()) && Objects.equals(this.stackPolicyDuringUpdateURL(), other.stackPolicyDuringUpdateURL()) && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && Objects.equals(this.resourceTypes(), other.resourceTypes()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.rollbackConfiguration(), other.rollbackConfiguration()) && Objects.equals(this.stackPolicyBody(), other.stackPolicyBody()) && Objects.equals(this.stackPolicyURL(), other.stackPolicyURL()) && Objects.equals(this.notificationARNs(), other.notificationARNs()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"UpdateStackRequest").add("StackName", (Object)this.stackName()).add("TemplateBody", (Object)this.templateBody()).add("TemplateURL", (Object)this.templateURL()).add("UsePreviousTemplate", (Object)this.usePreviousTemplate()).add("StackPolicyDuringUpdateBody", (Object)this.stackPolicyDuringUpdateBody()).add("StackPolicyDuringUpdateURL", (Object)this.stackPolicyDuringUpdateURL()).add("Parameters", this.parameters()).add("Capabilities", this.capabilitiesAsStrings()).add("ResourceTypes", this.resourceTypes()).add("RoleARN", (Object)this.roleARN()).add("RollbackConfiguration", (Object)this.rollbackConfiguration()).add("StackPolicyBody", (Object)this.stackPolicyBody()).add("StackPolicyURL", (Object)this.stackPolicyURL()).add("NotificationARNs", this.notificationARNs()).add("Tags", this.tags()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.ofNullable(clazz.cast(this.templateURL()));
            }
            case "UsePreviousTemplate": {
                return Optional.ofNullable(clazz.cast(this.usePreviousTemplate()));
            }
            case "StackPolicyDuringUpdateBody": {
                return Optional.ofNullable(clazz.cast(this.stackPolicyDuringUpdateBody()));
            }
            case "StackPolicyDuringUpdateURL": {
                return Optional.ofNullable(clazz.cast(this.stackPolicyDuringUpdateURL()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypes()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "RollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rollbackConfiguration()));
            }
            case "StackPolicyBody": {
                return Optional.ofNullable(clazz.cast(this.stackPolicyBody()));
            }
            case "StackPolicyURL": {
                return Optional.ofNullable(clazz.cast(this.stackPolicyURL()));
            }
            case "NotificationARNs": {
                return Optional.ofNullable(clazz.cast(this.notificationARNs()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStackRequest, T> g) {
        return obj -> g.apply((UpdateStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String templateBody;
        private String templateURL;
        private Boolean usePreviousTemplate;
        private String stackPolicyDuringUpdateBody;
        private String stackPolicyDuringUpdateURL;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private String roleARN;
        private RollbackConfiguration rollbackConfiguration;
        private String stackPolicyBody;
        private String stackPolicyURL;
        private List<String> notificationARNs = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.usePreviousTemplate(model.usePreviousTemplate);
            this.stackPolicyDuringUpdateBody(model.stackPolicyDuringUpdateBody);
            this.stackPolicyDuringUpdateURL(model.stackPolicyDuringUpdateURL);
            this.parameters(model.parameters);
            this.capabilitiesWithStrings(model.capabilities);
            this.resourceTypes(model.resourceTypes);
            this.roleARN(model.roleARN);
            this.rollbackConfiguration(model.rollbackConfiguration);
            this.stackPolicyBody(model.stackPolicyBody);
            this.stackPolicyURL(model.stackPolicyURL);
            this.notificationARNs(model.notificationARNs);
            this.tags(model.tags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Boolean getUsePreviousTemplate() {
            return this.usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        public final String getStackPolicyDuringUpdateBody() {
            return this.stackPolicyDuringUpdateBody;
        }

        @Override
        public final Builder stackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
            return this;
        }

        public final void setStackPolicyDuringUpdateBody(String stackPolicyDuringUpdateBody) {
            this.stackPolicyDuringUpdateBody = stackPolicyDuringUpdateBody;
        }

        public final String getStackPolicyDuringUpdateURL() {
            return this.stackPolicyDuringUpdateURL;
        }

        @Override
        public final Builder stackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
            return this;
        }

        public final void setStackPolicyDuringUpdateURL(String stackPolicyDuringUpdateURL) {
            this.stackPolicyDuringUpdateURL = stackPolicyDuringUpdateURL;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final RollbackConfiguration.Builder getRollbackConfiguration() {
            return this.rollbackConfiguration != null ? this.rollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rollbackConfiguration(RollbackConfiguration rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration;
            return this;
        }

        public final void setRollbackConfiguration(RollbackConfiguration.BuilderImpl rollbackConfiguration) {
            this.rollbackConfiguration = rollbackConfiguration != null ? rollbackConfiguration.build() : null;
        }

        public final String getStackPolicyBody() {
            return this.stackPolicyBody;
        }

        @Override
        public final Builder stackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
            return this;
        }

        public final void setStackPolicyBody(String stackPolicyBody) {
            this.stackPolicyBody = stackPolicyBody;
        }

        public final String getStackPolicyURL() {
            return this.stackPolicyURL;
        }

        @Override
        public final Builder stackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
            return this;
        }

        public final void setStackPolicyURL(String stackPolicyURL) {
            this.stackPolicyURL = stackPolicyURL;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            this.notificationARNs(Arrays.asList(notificationARNs));
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackRequest build() {
            return new UpdateStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStackRequest> {
        public Builder stackName(String var1);

        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder usePreviousTemplate(Boolean var1);

        public Builder stackPolicyDuringUpdateBody(String var1);

        public Builder stackPolicyDuringUpdateURL(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder roleARN(String var1);

        public Builder rollbackConfiguration(RollbackConfiguration var1);

        default public Builder rollbackConfiguration(Consumer<RollbackConfiguration.Builder> rollbackConfiguration) {
            return this.rollbackConfiguration((RollbackConfiguration)((RollbackConfiguration.Builder)RollbackConfiguration.builder().applyMutation(rollbackConfiguration)).build());
        }

        public Builder stackPolicyBody(String var1);

        public Builder stackPolicyURL(String var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

