/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.AccountListCopier;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.DeploymentTargets;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.RegionListCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStackInstancesRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, UpdateStackInstancesRequest> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(UpdateStackInstancesRequest.getter(UpdateStackInstancesRequest::stackSetName)).setter(UpdateStackInstancesRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<List<String>> ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Accounts").getter(UpdateStackInstancesRequest.getter(UpdateStackInstancesRequest::accounts)).setter(UpdateStackInstancesRequest.setter(Builder::accounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Accounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentTargets> DEPLOYMENT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeploymentTargets").getter(UpdateStackInstancesRequest.getter(UpdateStackInstancesRequest::deploymentTargets)).setter(UpdateStackInstancesRequest.setter(Builder::deploymentTargets)).constructor(DeploymentTargets::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentTargets").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(UpdateStackInstancesRequest.getter(UpdateStackInstancesRequest::regions)).setter(UpdateStackInstancesRequest.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Parameter>> PARAMETER_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParameterOverrides").getter(UpdateStackInstancesRequest.getter(UpdateStackInstancesRequest::parameterOverrides)).setter(UpdateStackInstancesRequest.setter(Builder::parameterOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StackSetOperationPreferences> OPERATION_PREFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OperationPreferences").getter(UpdateStackInstancesRequest.getter(UpdateStackInstancesRequest::operationPreferences)).setter(UpdateStackInstancesRequest.setter(Builder::operationPreferences)).constructor(StackSetOperationPreferences::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationPreferences").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(UpdateStackInstancesRequest.getter(UpdateStackInstancesRequest::operationId)).setter(UpdateStackInstancesRequest.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, ACCOUNTS_FIELD, DEPLOYMENT_TARGETS_FIELD, REGIONS_FIELD, PARAMETER_OVERRIDES_FIELD, OPERATION_PREFERENCES_FIELD, OPERATION_ID_FIELD));
    private final String stackSetName;
    private final List<String> accounts;
    private final DeploymentTargets deploymentTargets;
    private final List<String> regions;
    private final List<Parameter> parameterOverrides;
    private final StackSetOperationPreferences operationPreferences;
    private final String operationId;

    private UpdateStackInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.stackSetName = builder.stackSetName;
        this.accounts = builder.accounts;
        this.deploymentTargets = builder.deploymentTargets;
        this.regions = builder.regions;
        this.parameterOverrides = builder.parameterOverrides;
        this.operationPreferences = builder.operationPreferences;
        this.operationId = builder.operationId;
    }

    public String stackSetName() {
        return this.stackSetName;
    }

    public boolean hasAccounts() {
        return this.accounts != null && !(this.accounts instanceof SdkAutoConstructList);
    }

    public List<String> accounts() {
        return this.accounts;
    }

    public DeploymentTargets deploymentTargets() {
        return this.deploymentTargets;
    }

    public boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public List<String> regions() {
        return this.regions;
    }

    public boolean hasParameterOverrides() {
        return this.parameterOverrides != null && !(this.parameterOverrides instanceof SdkAutoConstructList);
    }

    public List<Parameter> parameterOverrides() {
        return this.parameterOverrides;
    }

    public StackSetOperationPreferences operationPreferences() {
        return this.operationPreferences;
    }

    public String operationId() {
        return this.operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccounts() ? this.accounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTargets());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterOverrides() ? this.parameterOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operationPreferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStackInstancesRequest)) {
            return false;
        }
        UpdateStackInstancesRequest other = (UpdateStackInstancesRequest)((Object)obj);
        return Objects.equals(this.stackSetName(), other.stackSetName()) && this.hasAccounts() == other.hasAccounts() && Objects.equals(this.accounts(), other.accounts()) && Objects.equals(this.deploymentTargets(), other.deploymentTargets()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && this.hasParameterOverrides() == other.hasParameterOverrides() && Objects.equals(this.parameterOverrides(), other.parameterOverrides()) && Objects.equals(this.operationPreferences(), other.operationPreferences()) && Objects.equals(this.operationId(), other.operationId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateStackInstancesRequest").add("StackSetName", (Object)this.stackSetName()).add("Accounts", this.hasAccounts() ? this.accounts() : null).add("DeploymentTargets", (Object)this.deploymentTargets()).add("Regions", this.hasRegions() ? this.regions() : null).add("ParameterOverrides", this.hasParameterOverrides() ? this.parameterOverrides() : null).add("OperationPreferences", (Object)this.operationPreferences()).add("OperationId", (Object)this.operationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "Accounts": {
                return Optional.ofNullable(clazz.cast(this.accounts()));
            }
            case "DeploymentTargets": {
                return Optional.ofNullable(clazz.cast(this.deploymentTargets()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "ParameterOverrides": {
                return Optional.ofNullable(clazz.cast(this.parameterOverrides()));
            }
            case "OperationPreferences": {
                return Optional.ofNullable(clazz.cast(this.operationPreferences()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStackInstancesRequest, T> g) {
        return obj -> g.apply((UpdateStackInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackSetName;
        private List<String> accounts = DefaultSdkAutoConstructList.getInstance();
        private DeploymentTargets deploymentTargets;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private List<Parameter> parameterOverrides = DefaultSdkAutoConstructList.getInstance();
        private StackSetOperationPreferences operationPreferences;
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStackInstancesRequest model) {
            super(model);
            this.stackSetName(model.stackSetName);
            this.accounts(model.accounts);
            this.deploymentTargets(model.deploymentTargets);
            this.regions(model.regions);
            this.parameterOverrides(model.parameterOverrides);
            this.operationPreferences(model.operationPreferences);
            this.operationId(model.operationId);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        public final Collection<String> getAccounts() {
            if (this.accounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.accounts;
        }

        @Override
        public final Builder accounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accounts(String ... accounts) {
            this.accounts(Arrays.asList(accounts));
            return this;
        }

        public final void setAccounts(Collection<String> accounts) {
            this.accounts = AccountListCopier.copy(accounts);
        }

        public final DeploymentTargets.Builder getDeploymentTargets() {
            return this.deploymentTargets != null ? this.deploymentTargets.toBuilder() : null;
        }

        @Override
        public final Builder deploymentTargets(DeploymentTargets deploymentTargets) {
            this.deploymentTargets = deploymentTargets;
            return this;
        }

        public final void setDeploymentTargets(DeploymentTargets.BuilderImpl deploymentTargets) {
            this.deploymentTargets = deploymentTargets != null ? deploymentTargets.build() : null;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        public final Collection<Parameter.Builder> getParameterOverrides() {
            if (this.parameterOverrides instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parameterOverrides != null ? (Collection)this.parameterOverrides.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterOverrides(Collection<Parameter> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Parameter ... parameterOverrides) {
            this.parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<Parameter.Builder> ... parameterOverrides) {
            this.parameterOverrides(Stream.of(parameterOverrides).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterOverrides(Collection<Parameter.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ParametersCopier.copyFromBuilder(parameterOverrides);
        }

        public final StackSetOperationPreferences.Builder getOperationPreferences() {
            return this.operationPreferences != null ? this.operationPreferences.toBuilder() : null;
        }

        @Override
        public final Builder operationPreferences(StackSetOperationPreferences operationPreferences) {
            this.operationPreferences = operationPreferences;
            return this;
        }

        public final void setOperationPreferences(StackSetOperationPreferences.BuilderImpl operationPreferences) {
            this.operationPreferences = operationPreferences != null ? operationPreferences.build() : null;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStackInstancesRequest build() {
            return new UpdateStackInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStackInstancesRequest> {
        public Builder stackSetName(String var1);

        public Builder accounts(Collection<String> var1);

        public Builder accounts(String ... var1);

        public Builder deploymentTargets(DeploymentTargets var1);

        default public Builder deploymentTargets(Consumer<DeploymentTargets.Builder> deploymentTargets) {
            return this.deploymentTargets((DeploymentTargets)((DeploymentTargets.Builder)DeploymentTargets.builder().applyMutation(deploymentTargets)).build());
        }

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder parameterOverrides(Collection<Parameter> var1);

        public Builder parameterOverrides(Parameter ... var1);

        public Builder parameterOverrides(Consumer<Parameter.Builder> ... var1);

        public Builder operationPreferences(StackSetOperationPreferences var1);

        default public Builder operationPreferences(Consumer<StackSetOperationPreferences.Builder> operationPreferences) {
            return this.operationPreferences((StackSetOperationPreferences)((StackSetOperationPreferences.Builder)StackSetOperationPreferences.builder().applyMutation(operationPreferences)).build());
        }

        public Builder operationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

