/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.TypeVersionSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.TypeVersionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypeVersionsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListTypeVersionsResponse> {
    private static final SdkField<List<TypeVersionSummary>> TYPE_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TypeVersionSummaries").getter(ListTypeVersionsResponse.getter(ListTypeVersionsResponse::typeVersionSummaries)).setter(ListTypeVersionsResponse.setter(Builder::typeVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypeVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTypeVersionsResponse.getter(ListTypeVersionsResponse::nextToken)).setter(ListTypeVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<TypeVersionSummary> typeVersionSummaries;
    private final String nextToken;

    private ListTypeVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.typeVersionSummaries = builder.typeVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTypeVersionSummaries() {
        return this.typeVersionSummaries != null && !(this.typeVersionSummaries instanceof SdkAutoConstructList);
    }

    public List<TypeVersionSummary> typeVersionSummaries() {
        return this.typeVersionSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypeVersionSummaries() ? this.typeVersionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypeVersionsResponse)) {
            return false;
        }
        ListTypeVersionsResponse other = (ListTypeVersionsResponse)((Object)obj);
        return this.hasTypeVersionSummaries() == other.hasTypeVersionSummaries() && Objects.equals(this.typeVersionSummaries(), other.typeVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTypeVersionsResponse").add("TypeVersionSummaries", this.hasTypeVersionSummaries() ? this.typeVersionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.typeVersionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypeVersionsResponse, T> g) {
        return obj -> g.apply((ListTypeVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<TypeVersionSummary> typeVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypeVersionsResponse model) {
            super(model);
            this.typeVersionSummaries(model.typeVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<TypeVersionSummary.Builder> getTypeVersionSummaries() {
            if (this.typeVersionSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.typeVersionSummaries != null ? (Collection)this.typeVersionSummaries.stream().map(TypeVersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder typeVersionSummaries(Collection<TypeVersionSummary> typeVersionSummaries) {
            this.typeVersionSummaries = TypeVersionSummariesCopier.copy(typeVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeVersionSummaries(TypeVersionSummary ... typeVersionSummaries) {
            this.typeVersionSummaries(Arrays.asList(typeVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeVersionSummaries(Consumer<TypeVersionSummary.Builder> ... typeVersionSummaries) {
            this.typeVersionSummaries(Stream.of(typeVersionSummaries).map(c -> (TypeVersionSummary)((TypeVersionSummary.Builder)TypeVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTypeVersionSummaries(Collection<TypeVersionSummary.BuilderImpl> typeVersionSummaries) {
            this.typeVersionSummaries = TypeVersionSummariesCopier.copyFromBuilder(typeVersionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypeVersionsResponse build() {
            return new ListTypeVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypeVersionsResponse> {
        public Builder typeVersionSummaries(Collection<TypeVersionSummary> var1);

        public Builder typeVersionSummaries(TypeVersionSummary ... var1);

        public Builder typeVersionSummaries(Consumer<TypeVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

