/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StageListCopier;
import software.amazon.awssdk.services.cloudformation.model.TemplateStage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, GetTemplateResponse> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(GetTemplateResponse.getter(GetTemplateResponse::templateBody)).setter(GetTemplateResponse.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<List<String>> STAGES_AVAILABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StagesAvailable").getter(GetTemplateResponse.getter(GetTemplateResponse::stagesAvailableAsStrings)).setter(GetTemplateResponse.setter(Builder::stagesAvailableWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StagesAvailable").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD, STAGES_AVAILABLE_FIELD));
    private final String templateBody;
    private final List<String> stagesAvailable;

    private GetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.stagesAvailable = builder.stagesAvailable;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public List<TemplateStage> stagesAvailable() {
        return StageListCopier.copyStringToEnum(this.stagesAvailable);
    }

    public boolean hasStagesAvailable() {
        return this.stagesAvailable != null && !(this.stagesAvailable instanceof SdkAutoConstructList);
    }

    public List<String> stagesAvailableAsStrings() {
        return this.stagesAvailable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagesAvailableAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateResponse)) {
            return false;
        }
        GetTemplateResponse other = (GetTemplateResponse)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.stagesAvailableAsStrings(), other.stagesAvailableAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"GetTemplateResponse").add("TemplateBody", (Object)this.templateBody()).add("StagesAvailable", this.stagesAvailableAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "StagesAvailable": {
                return Optional.ofNullable(clazz.cast(this.stagesAvailableAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateResponse, T> g) {
        return obj -> g.apply((GetTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String templateBody;
        private List<String> stagesAvailable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateResponse model) {
            super(model);
            this.templateBody(model.templateBody);
            this.stagesAvailableWithStrings(model.stagesAvailable);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final Collection<String> getStagesAvailable() {
            return this.stagesAvailable;
        }

        @Override
        public final Builder stagesAvailableWithStrings(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailableWithStrings(String ... stagesAvailable) {
            this.stagesAvailableWithStrings(Arrays.asList(stagesAvailable));
            return this;
        }

        @Override
        public final Builder stagesAvailable(Collection<TemplateStage> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copyEnumToString(stagesAvailable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesAvailable(TemplateStage ... stagesAvailable) {
            this.stagesAvailable(Arrays.asList(stagesAvailable));
            return this;
        }

        public final void setStagesAvailable(Collection<String> stagesAvailable) {
            this.stagesAvailable = StageListCopier.copy(stagesAvailable);
        }

        @Override
        public GetTemplateResponse build() {
            return new GetTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateResponse> {
        public Builder templateBody(String var1);

        public Builder stagesAvailableWithStrings(Collection<String> var1);

        public Builder stagesAvailableWithStrings(String ... var1);

        public Builder stagesAvailable(Collection<TemplateStage> var1);

        public Builder stagesAvailable(TemplateStage ... var1);
    }
}

