/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::parameterKey)).setter(Parameter.setter(Builder::parameterKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterKey").build()}).build();
    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::parameterValue)).setter(Parameter.setter(Builder::parameterValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValue").build()}).build();
    private static final SdkField<Boolean> USE_PREVIOUS_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Parameter.getter(Parameter::usePreviousValue)).setter(Parameter.setter(Builder::usePreviousValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsePreviousValue").build()}).build();
    private static final SdkField<String> RESOLVED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Parameter.getter(Parameter::resolvedValue)).setter(Parameter.setter(Builder::resolvedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResolvedValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD, PARAMETER_VALUE_FIELD, USE_PREVIOUS_VALUE_FIELD, RESOLVED_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterKey;
    private final String parameterValue;
    private final Boolean usePreviousValue;
    private final String resolvedValue;

    private Parameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
        this.usePreviousValue = builder.usePreviousValue;
        this.resolvedValue = builder.resolvedValue;
    }

    public String parameterKey() {
        return this.parameterKey;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public Boolean usePreviousValue() {
        return this.usePreviousValue;
    }

    public String resolvedValue() {
        return this.resolvedValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePreviousValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolvedValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.parameterKey(), other.parameterKey()) && Objects.equals(this.parameterValue(), other.parameterValue()) && Objects.equals(this.usePreviousValue(), other.usePreviousValue()) && Objects.equals(this.resolvedValue(), other.resolvedValue());
    }

    public String toString() {
        return ToString.builder((String)"Parameter").add("ParameterKey", (Object)this.parameterKey()).add("ParameterValue", (Object)this.parameterValue()).add("UsePreviousValue", (Object)this.usePreviousValue()).add("ResolvedValue", (Object)this.resolvedValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterKey": {
                return Optional.ofNullable(clazz.cast(this.parameterKey()));
            }
            case "ParameterValue": {
                return Optional.ofNullable(clazz.cast(this.parameterValue()));
            }
            case "UsePreviousValue": {
                return Optional.ofNullable(clazz.cast(this.usePreviousValue()));
            }
            case "ResolvedValue": {
                return Optional.ofNullable(clazz.cast(this.resolvedValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parameter, T> g) {
        return obj -> g.apply((Parameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterKey;
        private String parameterValue;
        private Boolean usePreviousValue;
        private String resolvedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.parameterKey(model.parameterKey);
            this.parameterValue(model.parameterValue);
            this.usePreviousValue(model.usePreviousValue);
            this.resolvedValue(model.resolvedValue);
        }

        public final String getParameterKey() {
            return this.parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final Boolean getUsePreviousValue() {
            return this.usePreviousValue;
        }

        @Override
        public final Builder usePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
            return this;
        }

        public final void setUsePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
        }

        public final String getResolvedValue() {
            return this.resolvedValue;
        }

        @Override
        public final Builder resolvedValue(String resolvedValue) {
            this.resolvedValue = resolvedValue;
            return this;
        }

        public final void setResolvedValue(String resolvedValue) {
            this.resolvedValue = resolvedValue;
        }

        public Parameter build() {
            return new Parameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parameter> {
        public Builder parameterKey(String var1);

        public Builder parameterValue(String var1);

        public Builder usePreviousValue(Boolean var1);

        public Builder resolvedValue(String var1);
    }
}

