/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTypeResponse extends CloudFormationResponse implements
        ToCopyableBuilder<RegisterTypeResponse.Builder, RegisterTypeResponse> {
    private static final SdkField<String> REGISTRATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterTypeResponse::registrationToken)).setter(setter(Builder::registrationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TOKEN_FIELD));

    private final String registrationToken;

    private RegisterTypeResponse(BuilderImpl builder) {
        super(builder);
        this.registrationToken = builder.registrationToken;
    }

    /**
     * <p>
     * The identifier for this registration request.
     * </p>
     * <p>
     * Use this registration token when calling <code> <a>DescribeTypeRegistration</a> </code>, which returns
     * information about the status and IDs of the type registration.
     * </p>
     * 
     * @return The identifier for this registration request.</p>
     *         <p>
     *         Use this registration token when calling <code> <a>DescribeTypeRegistration</a> </code>, which returns
     *         information about the status and IDs of the type registration.
     */
    public String registrationToken() {
        return registrationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registrationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTypeResponse)) {
            return false;
        }
        RegisterTypeResponse other = (RegisterTypeResponse) obj;
        return Objects.equals(registrationToken(), other.registrationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RegisterTypeResponse").add("RegistrationToken", registrationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegistrationToken":
            return Optional.ofNullable(clazz.cast(registrationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTypeResponse, T> g) {
        return obj -> g.apply((RegisterTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, RegisterTypeResponse> {
        /**
         * <p>
         * The identifier for this registration request.
         * </p>
         * <p>
         * Use this registration token when calling <code> <a>DescribeTypeRegistration</a> </code>, which returns
         * information about the status and IDs of the type registration.
         * </p>
         * 
         * @param registrationToken
         *        The identifier for this registration request.</p>
         *        <p>
         *        Use this registration token when calling <code> <a>DescribeTypeRegistration</a> </code>, which returns
         *        information about the status and IDs of the type registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationToken(String registrationToken);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String registrationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTypeResponse model) {
            super(model);
            registrationToken(model.registrationToken);
        }

        public final String getRegistrationToken() {
            return registrationToken;
        }

        @Override
        public final Builder registrationToken(String registrationToken) {
            this.registrationToken = registrationToken;
            return this;
        }

        public final void setRegistrationToken(String registrationToken) {
            this.registrationToken = registrationToken;
        }

        @Override
        public RegisterTypeResponse build() {
            return new RegisterTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
