/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudformation.model.ResourceIdentifierPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceToImport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceToImport> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceToImport.getter(ResourceToImport::resourceType)).setter(ResourceToImport.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> LOGICAL_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceToImport.getter(ResourceToImport::logicalResourceId)).setter(ResourceToImport.setter(Builder::logicalResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalResourceId").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ResourceToImport.getter(ResourceToImport::resourceIdentifier)).setter(ResourceToImport.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, LOGICAL_RESOURCE_ID_FIELD, RESOURCE_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String logicalResourceId;
    private final Map<String, String> resourceIdentifier;

    private ResourceToImport(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.logicalResourceId = builder.logicalResourceId;
        this.resourceIdentifier = builder.resourceIdentifier;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public boolean hasResourceIdentifier() {
        return this.resourceIdentifier != null && !(this.resourceIdentifier instanceof SdkAutoConstructMap);
    }

    public Map<String, String> resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceToImport)) {
            return false;
        }
        ResourceToImport other = (ResourceToImport)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"ResourceToImport").add("ResourceType", (Object)this.resourceType()).add("LogicalResourceId", (Object)this.logicalResourceId()).add("ResourceIdentifier", this.resourceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceToImport, T> g) {
        return obj -> g.apply((ResourceToImport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String logicalResourceId;
        private Map<String, String> resourceIdentifier = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceToImport model) {
            this.resourceType(model.resourceType);
            this.logicalResourceId(model.logicalResourceId);
            this.resourceIdentifier(model.resourceIdentifier);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final Map<String, String> getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(Map<String, String> resourceIdentifier) {
            this.resourceIdentifier = ResourceIdentifierPropertiesCopier.copy(resourceIdentifier);
            return this;
        }

        public final void setResourceIdentifier(Map<String, String> resourceIdentifier) {
            this.resourceIdentifier = ResourceIdentifierPropertiesCopier.copy(resourceIdentifier);
        }

        public ResourceToImport build() {
            return new ResourceToImport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceToImport> {
        public Builder resourceType(String var1);

        public Builder logicalResourceId(String var1);

        public Builder resourceIdentifier(Map<String, String> var1);
    }
}

