/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingConfig> {
    private static final SdkField<String> LOG_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LoggingConfig.getter(LoggingConfig::logRoleArn)).setter(LoggingConfig.setter(Builder::logRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogRoleArn").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LoggingConfig.getter(LoggingConfig::logGroupName)).setter(LoggingConfig.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_ROLE_ARN_FIELD, LOG_GROUP_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logRoleArn;
    private final String logGroupName;

    private LoggingConfig(BuilderImpl builder) {
        this.logRoleArn = builder.logRoleArn;
        this.logGroupName = builder.logGroupName;
    }

    public String logRoleArn() {
        return this.logRoleArn;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig)obj;
        return Objects.equals(this.logRoleArn(), other.logRoleArn()) && Objects.equals(this.logGroupName(), other.logGroupName());
    }

    public String toString() {
        return ToString.builder((String)"LoggingConfig").add("LogRoleArn", (Object)this.logRoleArn()).add("LogGroupName", (Object)this.logGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogRoleArn": {
                return Optional.ofNullable(clazz.cast(this.logRoleArn()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logRoleArn;
        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            this.logRoleArn(model.logRoleArn);
            this.logGroupName(model.logGroupName);
        }

        public final String getLogRoleArn() {
            return this.logRoleArn;
        }

        @Override
        public final Builder logRoleArn(String logRoleArn) {
            this.logRoleArn = logRoleArn;
            return this;
        }

        public final void setLogRoleArn(String logRoleArn) {
            this.logRoleArn = logRoleArn;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingConfig> {
        public Builder logRoleArn(String var1);

        public Builder logGroupName(String var1);
    }
}

