/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackSetsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStackSetsResponse> {
    private static final SdkField<List<StackSetSummary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListStackSetsResponse.getter(ListStackSetsResponse::summaries)).setter(ListStackSetsResponse.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListStackSetsResponse.getter(ListStackSetsResponse::nextToken)).setter(ListStackSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<StackSetSummary> summaries;
    private final String nextToken;

    private ListStackSetsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public List<StackSetSummary> summaries() {
        return this.summaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.summaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackSetsResponse)) {
            return false;
        }
        ListStackSetsResponse other = (ListStackSetsResponse)((Object)obj);
        return Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListStackSetsResponse").add("Summaries", this.summaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStackSetsResponse, T> g) {
        return obj -> g.apply((ListStackSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackSetSummary> summaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackSetsResponse model) {
            super(model);
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<StackSetSummary.Builder> getSummaries() {
            return this.summaries != null ? (Collection)this.summaries.stream().map(StackSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<StackSetSummary> summaries) {
            this.summaries = StackSetSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(StackSetSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<StackSetSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (StackSetSummary)((StackSetSummary.Builder)StackSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<StackSetSummary.BuilderImpl> summaries) {
            this.summaries = StackSetSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListStackSetsResponse build() {
            return new ListStackSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStackSetsResponse> {
        public Builder summaries(Collection<StackSetSummary> var1);

        public Builder summaries(StackSetSummary ... var1);

        public Builder summaries(Consumer<StackSetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

