/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.RegistrationTokenListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypeRegistrationsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListTypeRegistrationsResponse> {
    private static final SdkField<List<String>> REGISTRATION_TOKEN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTypeRegistrationsResponse.getter(ListTypeRegistrationsResponse::registrationTokenList)).setter(ListTypeRegistrationsResponse.setter(Builder::registrationTokenList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationTokenList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTypeRegistrationsResponse.getter(ListTypeRegistrationsResponse::nextToken)).setter(ListTypeRegistrationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRATION_TOKEN_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> registrationTokenList;
    private final String nextToken;

    private ListTypeRegistrationsResponse(BuilderImpl builder) {
        super(builder);
        this.registrationTokenList = builder.registrationTokenList;
        this.nextToken = builder.nextToken;
    }

    public List<String> registrationTokenList() {
        return this.registrationTokenList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationTokenList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypeRegistrationsResponse)) {
            return false;
        }
        ListTypeRegistrationsResponse other = (ListTypeRegistrationsResponse)((Object)obj);
        return Objects.equals(this.registrationTokenList(), other.registrationTokenList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTypeRegistrationsResponse").add("RegistrationTokenList", this.registrationTokenList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegistrationTokenList": {
                return Optional.ofNullable(clazz.cast(this.registrationTokenList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypeRegistrationsResponse, T> g) {
        return obj -> g.apply((ListTypeRegistrationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<String> registrationTokenList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypeRegistrationsResponse model) {
            super(model);
            this.registrationTokenList(model.registrationTokenList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getRegistrationTokenList() {
            return this.registrationTokenList;
        }

        @Override
        public final Builder registrationTokenList(Collection<String> registrationTokenList) {
            this.registrationTokenList = RegistrationTokenListCopier.copy(registrationTokenList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registrationTokenList(String ... registrationTokenList) {
            this.registrationTokenList(Arrays.asList(registrationTokenList));
            return this;
        }

        public final void setRegistrationTokenList(Collection<String> registrationTokenList) {
            this.registrationTokenList = RegistrationTokenListCopier.copy(registrationTokenList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTypeRegistrationsResponse build() {
            return new ListTypeRegistrationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypeRegistrationsResponse> {
        public Builder registrationTokenList(Collection<String> var1);

        public Builder registrationTokenList(String ... var1);

        public Builder nextToken(String var1);
    }
}

