/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.model.Export;
import software.amazon.awssdk.services.cloudformation.model.ListExportsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListExportsResponse;

public class ListExportsPublisher
implements SdkPublisher<ListExportsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExportsPublisher(CloudFormationAsyncClient client, ListExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExportsPublisher(CloudFormationAsyncClient client, ListExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Export> exports() {
        Function<ListExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.exports() != null) {
                return response.exports().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListExportsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListExportsPublisher resume(ListExportsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListExportsPublisher(this.client, (ListExportsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListExportsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListExportsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListExportsResponseFetcher
    implements AsyncPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListExportsResponse> nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsPublisher.this.client.listExports(ListExportsPublisher.this.firstRequest);
            }
            return ListExportsPublisher.this.client.listExports((ListExportsRequest)((Object)ListExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

