/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;

public class UpdateStackSetRequestMarshaller
implements Marshaller<Request<UpdateStackSetRequest>, UpdateStackSetRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<UpdateStackSetRequest> marshall(UpdateStackSetRequest updateStackSetRequest) {
        StackSetOperationPreferences stackSetOperationPreferences;
        List<Tag> tagsList;
        List<String> capabilitiesList;
        List<Parameter> parametersList;
        if (updateStackSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)updateStackSetRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)updateStackSetRequest.stackSetName()));
        }
        if (updateStackSetRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)updateStackSetRequest.description()));
        }
        if (updateStackSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)updateStackSetRequest.templateBody()));
        }
        if (updateStackSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)updateStackSetRequest.templateURL()));
        }
        if (updateStackSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)updateStackSetRequest.usePreviousTemplate()));
        }
        if ((parametersList = updateStackSetRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parameter : parametersList) {
                    if (parameter.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameter.parameterKey()));
                    }
                    if (parameter.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameter.parameterValue()));
                    }
                    if (parameter.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameter.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if ((capabilitiesList = updateStackSetRequest.capabilitiesStrings()) != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;
                for (String string : capabilitiesList) {
                    if (string != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)string));
                    }
                    ++capabilitiesListIndex;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((tagsList = updateStackSetRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if ((stackSetOperationPreferences = updateStackSetRequest.operationPreferences()) != null) {
            List<String> list = stackSetOperationPreferences.regionOrder();
            if (list != null) {
                if (!list.isEmpty()) {
                    int regionOrderListIndex = 1;
                    for (String regionOrderListValue : list) {
                        if (regionOrderListValue != null) {
                            request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                        }
                        ++regionOrderListIndex;
                    }
                } else {
                    request.addParameter("OperationPreferences.RegionOrder", "");
                }
            }
            if (stackSetOperationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)stackSetOperationPreferences.failureToleranceCount()));
            }
            if (stackSetOperationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)stackSetOperationPreferences.failureTolerancePercentage()));
            }
            if (stackSetOperationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)stackSetOperationPreferences.maxConcurrentCount()));
            }
            if (stackSetOperationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)stackSetOperationPreferences.maxConcurrentPercentage()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)updateStackSetRequest.operationId()));
        return request;
    }
}

