/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.SignalResourceRequest;

public class SignalResourceRequestMarshaller
implements Marshaller<Request<SignalResourceRequest>, SignalResourceRequest> {
    public Request<SignalResourceRequest> marshall(SignalResourceRequest signalResourceRequest) {
        if (signalResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)signalResourceRequest, "CloudFormationClient");
        request.addParameter("Action", "SignalResource");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (signalResourceRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)signalResourceRequest.stackName()));
        }
        if (signalResourceRequest.logicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringUtils.fromString((String)signalResourceRequest.logicalResourceId()));
        }
        if (signalResourceRequest.uniqueId() != null) {
            request.addParameter("UniqueId", StringUtils.fromString((String)signalResourceRequest.uniqueId()));
        }
        if (signalResourceRequest.statusString() != null) {
            request.addParameter("Status", StringUtils.fromString((String)signalResourceRequest.statusString()));
        }
        return request;
    }
}

