/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;

public class EstimateTemplateCostRequestMarshaller
implements Marshaller<Request<EstimateTemplateCostRequest>, EstimateTemplateCostRequest> {
    public Request<EstimateTemplateCostRequest> marshall(EstimateTemplateCostRequest estimateTemplateCostRequest) {
        List<Parameter> parametersList;
        if (estimateTemplateCostRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)estimateTemplateCostRequest, "CloudFormationClient");
        request.addParameter("Action", "EstimateTemplateCost");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (estimateTemplateCostRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)estimateTemplateCostRequest.templateBody()));
        }
        if (estimateTemplateCostRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)estimateTemplateCostRequest.templateURL()));
        }
        if ((parametersList = estimateTemplateCostRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parametersListValue : parametersList) {
                    if (parametersListValue.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parametersListValue.parameterKey()));
                    }
                    if (parametersListValue.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.parameterValue()));
                    }
                    if (parametersListValue.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        return request;
    }
}

