/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration;
import software.amazon.awssdk.services.cloudformation.model.RollbackTrigger;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CreateStackRequestMarshaller
implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {
        List<Tag> list;
        List<String> resourceTypesList;
        List<String> capabilitiesList;
        List<String> notificationARNsList;
        RollbackConfiguration rollbackConfiguration;
        List<Parameter> parametersList;
        if (createStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createStackRequest.stackName()));
        }
        if (createStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createStackRequest.templateBody()));
        }
        if (createStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createStackRequest.templateURL()));
        }
        if ((parametersList = createStackRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parametersListValue : parametersList) {
                    if (parametersListValue.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parametersListValue.parameterKey()));
                    }
                    if (parametersListValue.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.parameterValue()));
                    }
                    if (parametersListValue.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if (createStackRequest.disableRollback() != null) {
            request.addParameter("DisableRollback", StringUtils.fromBoolean((Boolean)createStackRequest.disableRollback()));
        }
        if ((rollbackConfiguration = createStackRequest.rollbackConfiguration()) != null) {
            List<RollbackTrigger> rollbackTriggersList = rollbackConfiguration.rollbackTriggers();
            if (rollbackTriggersList != null) {
                if (!rollbackTriggersList.isEmpty()) {
                    int rollbackTriggersListIndex = 1;
                    for (RollbackTrigger rollbackTrigger : rollbackTriggersList) {
                        if (rollbackTrigger.arn() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Arn", StringUtils.fromString((String)rollbackTrigger.arn()));
                        }
                        if (rollbackTrigger.type() != null) {
                            request.addParameter("RollbackConfiguration.RollbackTriggers.member." + rollbackTriggersListIndex + ".Type", StringUtils.fromString((String)rollbackTrigger.type()));
                        }
                        ++rollbackTriggersListIndex;
                    }
                } else {
                    request.addParameter("RollbackConfiguration.RollbackTriggers", "");
                }
            }
            if (rollbackConfiguration.monitoringTimeInMinutes() != null) {
                request.addParameter("RollbackConfiguration.MonitoringTimeInMinutes", StringUtils.fromInteger((Integer)rollbackConfiguration.monitoringTimeInMinutes()));
            }
        }
        if (createStackRequest.timeoutInMinutes() != null) {
            request.addParameter("TimeoutInMinutes", StringUtils.fromInteger((Integer)createStackRequest.timeoutInMinutes()));
        }
        if ((notificationARNsList = createStackRequest.notificationARNs()) != null) {
            if (!notificationARNsList.isEmpty()) {
                int notificationARNsListIndex = 1;
                for (String string : notificationARNsList) {
                    if (string != null) {
                        request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)string));
                    }
                    ++notificationARNsListIndex;
                }
            } else {
                request.addParameter("NotificationARNs", "");
            }
        }
        if ((capabilitiesList = createStackRequest.capabilitiesStrings()) != null) {
            if (!capabilitiesList.isEmpty()) {
                int capabilitiesListIndex = 1;
                for (String string : capabilitiesList) {
                    if (string != null) {
                        request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)string));
                    }
                    ++capabilitiesListIndex;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((resourceTypesList = createStackRequest.resourceTypes()) != null) {
            if (!resourceTypesList.isEmpty()) {
                boolean bl = true;
                for (String resourceTypesListValue : resourceTypesList) {
                    void var8_20;
                    if (resourceTypesListValue != null) {
                        request.addParameter("ResourceTypes.member." + (int)var8_20, StringUtils.fromString((String)resourceTypesListValue));
                    }
                    ++var8_20;
                }
            } else {
                request.addParameter("ResourceTypes", "");
            }
        }
        if (createStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)createStackRequest.roleARN()));
        }
        if (createStackRequest.onFailureString() != null) {
            request.addParameter("OnFailure", StringUtils.fromString((String)createStackRequest.onFailureString()));
        }
        if (createStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)createStackRequest.stackPolicyBody()));
        }
        if (createStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)createStackRequest.stackPolicyURL()));
        }
        if ((list = createStackRequest.tags()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list) {
                    void var9_26;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var9_26 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var9_26 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var9_26;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)createStackRequest.clientRequestToken()));
        }
        if (createStackRequest.enableTerminationProtection() != null) {
            request.addParameter("EnableTerminationProtection", StringUtils.fromBoolean((Boolean)createStackRequest.enableTerminationProtection()));
        }
        return request;
    }
}

