/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.RegionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackSetOperationPreferences
implements ToCopyableBuilder<Builder, StackSetOperationPreferences> {
    private final List<String> regionOrder;
    private final Integer failureToleranceCount;
    private final Integer failureTolerancePercentage;
    private final Integer maxConcurrentCount;
    private final Integer maxConcurrentPercentage;

    private StackSetOperationPreferences(BuilderImpl builder) {
        this.regionOrder = builder.regionOrder;
        this.failureToleranceCount = builder.failureToleranceCount;
        this.failureTolerancePercentage = builder.failureTolerancePercentage;
        this.maxConcurrentCount = builder.maxConcurrentCount;
        this.maxConcurrentPercentage = builder.maxConcurrentPercentage;
    }

    public List<String> regionOrder() {
        return this.regionOrder;
    }

    public Integer failureToleranceCount() {
        return this.failureToleranceCount;
    }

    public Integer failureTolerancePercentage() {
        return this.failureTolerancePercentage;
    }

    public Integer maxConcurrentCount() {
        return this.maxConcurrentCount;
    }

    public Integer maxConcurrentPercentage() {
        return this.maxConcurrentPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.regionOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureToleranceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTolerancePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentPercentage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationPreferences)) {
            return false;
        }
        StackSetOperationPreferences other = (StackSetOperationPreferences)obj;
        return Objects.equals(this.regionOrder(), other.regionOrder()) && Objects.equals(this.failureToleranceCount(), other.failureToleranceCount()) && Objects.equals(this.failureTolerancePercentage(), other.failureTolerancePercentage()) && Objects.equals(this.maxConcurrentCount(), other.maxConcurrentCount()) && Objects.equals(this.maxConcurrentPercentage(), other.maxConcurrentPercentage());
    }

    public String toString() {
        return ToString.builder((String)"StackSetOperationPreferences").add("RegionOrder", this.regionOrder()).add("FailureToleranceCount", (Object)this.failureToleranceCount()).add("FailureTolerancePercentage", (Object)this.failureTolerancePercentage()).add("MaxConcurrentCount", (Object)this.maxConcurrentCount()).add("MaxConcurrentPercentage", (Object)this.maxConcurrentPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionOrder": {
                return Optional.of(clazz.cast(this.regionOrder()));
            }
            case "FailureToleranceCount": {
                return Optional.of(clazz.cast(this.failureToleranceCount()));
            }
            case "FailureTolerancePercentage": {
                return Optional.of(clazz.cast(this.failureTolerancePercentage()));
            }
            case "MaxConcurrentCount": {
                return Optional.of(clazz.cast(this.maxConcurrentCount()));
            }
            case "MaxConcurrentPercentage": {
                return Optional.of(clazz.cast(this.maxConcurrentPercentage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> regionOrder;
        private Integer failureToleranceCount;
        private Integer failureTolerancePercentage;
        private Integer maxConcurrentCount;
        private Integer maxConcurrentPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationPreferences model) {
            this.regionOrder(model.regionOrder);
            this.failureToleranceCount(model.failureToleranceCount);
            this.failureTolerancePercentage(model.failureTolerancePercentage);
            this.maxConcurrentCount(model.maxConcurrentCount);
            this.maxConcurrentPercentage(model.maxConcurrentPercentage);
        }

        public final Collection<String> getRegionOrder() {
            return this.regionOrder;
        }

        @Override
        public final Builder regionOrder(Collection<String> regionOrder) {
            this.regionOrder = RegionListCopier.copy(regionOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionOrder(String ... regionOrder) {
            this.regionOrder(Arrays.asList(regionOrder));
            return this;
        }

        public final void setRegionOrder(Collection<String> regionOrder) {
            this.regionOrder = RegionListCopier.copy(regionOrder);
        }

        public final Integer getFailureToleranceCount() {
            return this.failureToleranceCount;
        }

        @Override
        public final Builder failureToleranceCount(Integer failureToleranceCount) {
            this.failureToleranceCount = failureToleranceCount;
            return this;
        }

        public final void setFailureToleranceCount(Integer failureToleranceCount) {
            this.failureToleranceCount = failureToleranceCount;
        }

        public final Integer getFailureTolerancePercentage() {
            return this.failureTolerancePercentage;
        }

        @Override
        public final Builder failureTolerancePercentage(Integer failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
            return this;
        }

        public final void setFailureTolerancePercentage(Integer failureTolerancePercentage) {
            this.failureTolerancePercentage = failureTolerancePercentage;
        }

        public final Integer getMaxConcurrentCount() {
            return this.maxConcurrentCount;
        }

        @Override
        public final Builder maxConcurrentCount(Integer maxConcurrentCount) {
            this.maxConcurrentCount = maxConcurrentCount;
            return this;
        }

        public final void setMaxConcurrentCount(Integer maxConcurrentCount) {
            this.maxConcurrentCount = maxConcurrentCount;
        }

        public final Integer getMaxConcurrentPercentage() {
            return this.maxConcurrentPercentage;
        }

        @Override
        public final Builder maxConcurrentPercentage(Integer maxConcurrentPercentage) {
            this.maxConcurrentPercentage = maxConcurrentPercentage;
            return this;
        }

        public final void setMaxConcurrentPercentage(Integer maxConcurrentPercentage) {
            this.maxConcurrentPercentage = maxConcurrentPercentage;
        }

        public StackSetOperationPreferences build() {
            return new StackSetOperationPreferences(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSetOperationPreferences> {
        public Builder regionOrder(Collection<String> var1);

        public Builder regionOrder(String ... var1);

        public Builder failureToleranceCount(Integer var1);

        public Builder failureTolerancePercentage(Integer var1);

        public Builder maxConcurrentCount(Integer var1);

        public Builder maxConcurrentPercentage(Integer var1);
    }
}

