/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.GetTemplateRequest;

public class GetTemplateRequestMarshaller
implements Marshaller<Request<GetTemplateRequest>, GetTemplateRequest> {
    public Request<GetTemplateRequest> marshall(GetTemplateRequest getTemplateRequest) {
        if (getTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getTemplateRequest, "CloudFormationClient");
        request.addParameter("Action", "GetTemplate");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getTemplateRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)getTemplateRequest.stackName()));
        }
        if (getTemplateRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)getTemplateRequest.changeSetName()));
        }
        if (getTemplateRequest.templateStageString() != null) {
            request.addParameter("TemplateStage", StringUtils.fromString((String)getTemplateRequest.templateStageString()));
        }
        return request;
    }
}

